package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvents;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.PatientUriHelper;

public class DailyEventLinkBuilder extends AbstractSimplePatientDataLinkBuilder<DailyEvents, DailyEvent> {

	public DailyEventLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	protected String getDomainSpecificPath() {
		return "dailyevents";
	}

	@Override
	protected void fillCustomRelatedLinks(DailyEvent dataItem) {
		URI patientUri = PatientUriHelper.createPatientSelfUri(dataItem.getPatientIdentifier(), this.getBaseUri());
		URI documentsForDailyEvent = UriBuilder.fromUri(patientUri).path("documents").path("dailyEvents").path(dataItem.getUniqueId()).build();
		dataItem.getLink().addRelatedLink(LinkTitles.RelatedDocuments, documentsForDailyEvent);

        URI documentsForDailyEventPdf = UriBuilder.fromUri(patientUri).path(getDomainSpecificPath()).path(dataItem.getUniqueId()).path("pdf").build();
        dataItem.getLink().addRelatedLink("pdf", documentsForDailyEventPdf);
	}

	@Override
	protected boolean shouldIncludeCommunityIn      icalSelfUri() {
return true;
	}
	
}
