package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.NullChecker;

public class ChemistryLabTestLinkBuilder extends PatientDataLinkBuilder<LabTests, LabTest> {

	public ChemistryLabTestLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(LabTest dataItem) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(LabTest labTest) {
		fillResultsForTestLink(labTest);
	}

	private void fillResultsForTestLink(LabTest labTest) {
		URI patientUri = this.extractPatientUri(labTest);
		if (NullChecker.isNotNullish(labTest.getLoinc())) {
			URI labTestUri = UriBuilder.fromUri(patientUri).path("lab").path("results").path("system")
					.path(labTest.getDataIdentifier().getSystemId()).queryParam("loinc-code", labTest.getLoinc())
					.build();
			labTest.setLabResultsForTestUri(labTestUri);
		} else if(NullChecker.isNotNullish(labTest.getUniqueId()) && NullChecker.isNotNullish(labTest.getSpecimenName())){
			URI labTestUri = UriBuilder.fromUri(patientUri).path("lab").path("results").path("system")
					.path(labTest.getDataIdentifier().getSystemId()).queryParam("test", labTest.getUniqueId()).queryParam("specimen", labTest.getSpecimenName())
					.build();
			labTest.setLabResultsForTestUri(labTestUri);
		}
	}

	public void fillLabTestGroupLinks(LabTestGroups groups) {
		for (LabTestGroup group : groups) {
			fillCustomRelatedLinks(group.getLabTests());
		}
	}

	@Override
	protected void fillCustomRelatedLinks(LabTests labTests) {
		for (LabTest labTest : labTests) {
			fillResultsForTestLink(labTest);
		}
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

}
