package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.NullChecker;

public class ChemistryLabResultLinkBuilder extends PatientDataLinkBuilder<LabResults, LabResult> {

	public ChemistryLabResultLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(LabResult dataItem) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(LabResult LabResult) {
		fillResultsForTestLink(LabResult);
	}

	private void fillResultsForTestLink(LabResult labResult) {
		URI patientUri = this.extractPatientUri(labResult);
		if (NullChecker.isNotNullish(labResult.getLoinc())) {
			URI uriForResultsForTest = UriBuilder.fromUri(patientUri).path("lab").path("results").path("system")
					.path(labResult.getDataIdentifier().getSystemId()).queryParam("loinc-code", labResult.getLoinc()).build();
			labResult.getLink().addRelatedLink(LinkTitles.PatientChemistryLabResultsForTest, uriForResultsForTest);
		} else if (NullChecker.isNotNullish(labResult.getTestId()) && NullChecker.isNotNullish(labResult.getSpecimenName())){
			URI uriForResultsForTest = UriBuilder.fromUri(patientUri).path("lab").path("results").path("system")
					.path(labResult.getDataIdentifier().getSystemId()).queryParam("test", labResult.getTestId()).queryParam("specimen", labResult.getSpecimenName())
					.build();
			labResult.getLink().addRelatedLink(LinkTitles.PatientChemistryLabResultsForTest, uriForResultsForTest);
		}
	}

	@Override
	protected void fillCustomRelatedLinks(LabResults results) {
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

}
