package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.CalendarDirectory;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriDtoValidator;
import com.agilex.healthcare.utility.NullChecker;

public class CalendarLinkBuilder {
	private URI baseUri;

	public CalendarLinkBuilder(URI baseUri) {
		UriDtoValidator.validate(baseUri, "BaseUri is required in order to create data links.");
		this.baseUri = baseUri;
	}

	public CalendarDirectory createPatientCalendarResourceDirectory(PatientIdentifier patientIdentifier, String calendarKey) {
		CalendarDirectory calendarDirectory = new CalendarDirectory();

		if (NullChecker.isNotNullish(calendarKey)) {
			calendarDirectory.getLink()
					.addRelatedLink("PublicCalendarFeedByKey", UriBuilder.fromUri(getBaseUri()).path("public").path("calendar").path("key").path(calendarKey).path("feed").build());
			calendarDirectory.getLink().addRelatedLink("PublicCalendarEventsByKey",
					UriBuilder.fromUri(getBaseUri()).path("public").path("calendar").path("key").path(calendarKey).path("events").build());
		}
		if (patientIdentifier != null) {
			URI patientUri = PatientLinkBuilder.createPatientSelfUri(patientIdentifier, getBaseUri());
			calendarDirectory.getLink().addRelatedLink("PatientCalendarFeed", UriBuilder.fromUri(patientUri).path("calendar").path("feed").build());
			calendarDirectory.getLink().addRelatedLink("PatientCalendarEvents", UriBuilder.fromUri(patientUri).path("calendar").path("events").build());
		}

		return calendarDirectory;
	}

	private URI getBaseUri() {
		return this.baseUri;
	}

}
