package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;
import com.agilex.healthcare.mobilehealthplatform.domain.GraphData;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.PatientUriHelper;

public class AssessmentResultsLinkBuilder {
	private URI baseUri;

	public AssessmentResultsLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}

	public AssessmentResults fillLinks(AssessmentResults assessmentResults, URI resourceUri) {

		for (AssessmentResult assessmentResult : assessmentResults) {
			fillLinks(assessmentResult, null);
		}

		return assessmentResults;
	}

	public void fillLinks(AssessmentResult assessmentResult, URI resourceUri) {
		setSelfURI(assessmentResult);
	}

	public void fillLinks(GraphData data, URI resourceUri) {
		data.setSelfUri(resourceUri);
	}

	private void setSelfURI(AssessmentResult assessmentResult) {
		assessmentResult.setSelfUri(computeSelfURI(assessmentResult));
	}

	private URI computeSelfURI(AssessmentResult assessmentResult) {
		String resultId = assessmentResult.getUniqueId();
		String assessmentId = assessmentResult.getAssessmentId();

		URI patientUri = PatientUriHelper.createPatientSelfUri(assessmentResult.getPatientIdentifier(), this.baseUri);

		return UriBuilder.fromUri(patientUri).path("assessments").path("id").path(assessmentId).path("results").path("id").path(resultId).build();
	}

}
