package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.Assessment;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestion;
import com.agilex.healthcare.mobilehealthplatform.domain.Assessments;

public class AssessmentLinkBuilder {
	private URI baseUri;

	public AssessmentLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}

	public Assessments fillLinks(Assessments assessments, URI resourceUri) {
		assessments.setSelfUri(resourceUri);
		for (Assessment assessment : assessments) {
			fillLinks(assessment, null);
		}
		return assessments;
	}

	public Assessment fillLinks(Assessment assessment, URI resourceUri) {
		assessment.setSelfUri(computeSelfURI(assessment));
		
		for (AssessmentQuestion question : assessment.getQuestions()) {
			URI questionSelfURI = computeSelfURI(question, assessment.getSelfUri());
			assessment.getLink().addRelatedLink("Question " + question.getQuestionNumber(), questionSelfURI);
		}
		
		return assessment;
	}

	private URI computeSelfURI(Assessment assessment) {
		return UriBuilder.fromUri(baseUri).path("public").path("assessments").path("id").path(assessment.getId()).build();
	}

	public AssessmentQuestion fillLinks(AssessmentQuestion assessmentQuestion, URI resourceUri) {
		assessmentQuestion.setSelfUri(resourceUri);
		return assessmentQuestion;
	}

	private URI computeSelfURI(AssessmentQuestion question, URI assessmentPageSelfUri) {
		URI questionSelfUri = UriBuilder.fromUri(assessmentPageSelfUri).path("questions").path("id").path(question.getId()).build();
		return questionSelfUri;
	}

}
