package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;

public class AssessmentDraftsLinkBuilder {
	private URI baseUri;

	public AssessmentDraftsLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}

	public void fillLinks(AssessmentResults assessmentResults, URI resourceUri) {
		if (assessmentResults == null) {
			assessmentResults = new AssessmentResults();
		}
		setSelfURI(assessmentResults, resourceUri);
		populateRelatedLinks(assessmentResults, resourceUri);
	}

	public void fillLinks(AssessmentResult assessmentResult, URI resourceUri) {
		if (assessmentResult != null) {
			setSelfURI(assessmentResult, resourceUri);
		}
	}

	private void setSelfURI(AssessmentResults assessmentResults, URI resourceUri) {
		assessmentResults.setSelfUri(resourceUri);
	}

	private void setSelfURI(AssessmentResult assessmentResult, URI resourceUri) {
		URI assessmentResultsUri = generateDraftUri(assessmentResult, resourceUri);
		assessmentResult.setSelfUri(assessmentResultsUri);
	}

	private URI generateDraftUri(AssessmentResult assessmentResult, URI resourceUri) {
		String uniqueId = assessmentResult.getAssessmentId();
		URI assessmentResultUri = UriBuilder.fromUri(resourceUri).path("id").path(uniqueId).build();
		return assessmentResultUri;
	}

	private void populateRelatedLinks(AssessmentResults assessmentResults, URI resourceUri) {
		for (AssessmentResult assessmentResult : assessmentResults) {
			if (assessmentResult.isInProgress()) {
				URI draftURI = generateDraftUri(assessmentResult, resourceUri);
				assessmentResults.getLink().addRelatedLink(assessmentResult.getAssessmentId(), draftURI);
			}
		}
	}
}
