package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestMessages;

import javax.ws.rs.core.UriBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;

public class AppointmentRequestMessagesLinkBuilder extends PatientDataLinkBuilder<AppointmentRequestMessages, AppointmentRequestMessage> {

    public AppointmentRequestMessagesLinkBuilder(URI baseUri) {
        super(baseUri);
    }

    @Override
    public URI get      icalSelfUri(AppointmentRequestMessage dataItem) {
        String encodedUserId = encode(dataItem.getPatientId());
        String encodedAppointmentRequestId = encode(dataItem.getAppointmentRequestId());
//        @Path("/patient/{assigning-authority}/{patient-id}/appointment-requests/system/{system-id}/id/{appointment-request-id}/messages")
        URI selfUri = UriBuilder.fromUri(getBaseUri()).path("appointment-service").path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority())
                .path(encodedUserId).path("appointment-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedAppointmentRequestId).path("messages").build();

        return selfUri;

    }

    private String encode(String id) {
        String encoded;
        try {
            encoded = URLEncoder.encode(id, "UTF-8");
        } catch (UnsupportedEncodingException failedToEncode) {
            throw new RuntimeException("Could not encode a URL parameter for AppointmentRequests");
        }
        return encoded;
    }

    @Override
    public URI get      icalUriForCollection(URI patientUri) {
        return null;
    }

    @Override
    protected void fillCustomRelatedLinks(AppointmentRequestMessage dataItem) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    protected void fillCustomRelatedLinks(AppointmentRequestMessages dataList) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

}