package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.io.UnsupportedEncodingException;
import java.net.*;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.atom.rel;

public class AppointmentRequestLinkBuilder extends PatientDataLinkBuilder<AppointmentRequests, AppointmentRequest> {

	public AppointmentRequestLinkBuilder(URI baseUri) {
		super(baseUri);
	}
	
	@Override
	public URI get      icalSelfUri(AppointmentRequest dataItem) {
		String encodedUserId = getEncodedUserId(dataItem);
		String encodedAppointmentRequestId = encode(dataItem.getAppointmentRequestId());
		
		URI selfUri = UriBuilder.fromUri(getBaseUri()).path("appointment-service").path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority())
				.path(encodedUserId).path("appointments").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedAppointmentRequestId).build();
		
		return selfUri;
	}

    private String getEncodedUserId(AppointmentRequest dataItem) {
        return encode(dataItem.getPatientId());
    }

    @Override
	protected void fillCustomRelatedLinks(AppointmentRequest dataItem) {
		AtomLink link = new AtomLink();
		link.setRel(rel.related);
        String encodedUserId = getEncodedUserId(dataItem);
        String encodedAppointmentRequestId = encode(dataItem.getAppointmentRequestId());
        URI relatedUri = UriBuilder.fromUri(getBaseUri()).path("appointment-service").path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority())
                .path(encodedUserId).path("appointment-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedAppointmentRequestId).path("messages").build();

		link.setHref(relatedUri);
		link.setTitle(LinkTitles.AppointmentRequestMessages);
		dataItem.getLink().add(link);

        link = new AtomLink();
        link.setRel(rel.related);
        URI newMessageFlagUri = UriBuilder.fromUri(getBaseUri()).path("appointment-service").path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority())
                .path(encodedUserId).path("appointment-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedAppointmentRequestId).path("messages").path("read").build();
        link.setHref(newMessageFlagUri);
        link.setTitle(LinkTitles.AppointmentRequestNewMessageFlag);
        dataItem.getLink().add(link);

        link = new AtomLink();
        link.setRel(rel.related);
        URI newProviderSeenFlagUri = UriBuilder.fromUri(getBaseUri()).path("appointment-service").path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority())
                .path(encodedUserId).path("appointment-requests").path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(encodedAppointmentRequestId).path("appointment").path("provider-read").build();
        link.setHref(newProviderSeenFlagUri);
        link.setTitle(LinkTitles.AppointmentRequestProviderSeenFlag);
        dataItem.getLink().add(link);
    }
	
	@Override
	protected void fillCustomRelatedLinks(AppointmentRequests dataList) {
	}
	
	private String encode(String id) {
		String encoded;
		try {
			encoded = URLEncoder.encode(id, "UTF-8");
		} catch (UnsupportedEncodingException failedToEncode) {
			throw new RuntimeException("Could not encode a URL parameter for AppointmentRequests");
		}
		return encoded;
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

}