package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.AntibiogramURI;
import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.Organism;
import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.OrganismGroup;
import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.OrganismGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.Organisms;

public class AntibiogramLinkBuilder {
	
	URI baseUri;
	
	public AntibiogramLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}
	
	public void fillLinks(AntibiogramURI antibiogramURI, URI requestUri) {
		if(antibiogramURI != null) {
			antibiogramURI.setSelfUri(requestUri);
			fillRelatedLinks(antibiogramURI);
		}
	}
	
	public void fillRelatedLinks(AntibiogramURI antibiogramURI) {
		URI antibiogramBaseUri = UriBuilder.fromUri(baseUri).path("public").path("antibiogram").path("facility").build();
		antibiogramURI.getLink().addRelatedLink("antibiogram-facility-organism", UriBuilder.fromUri(antibiogramBaseUri).path(antibiogramURI.getFacilityCode()).path("organism-group").build());
		antibiogramURI.getLink().addRelatedLink("antibiogram-facility-matrix", UriBuilder.fromUri(antibiogramBaseUri).path(antibiogramURI.getFacilityCode()).path("matrix").build());
	}	
	
	public void fillLinks(Organisms organisms, URI requestUri) {
		if(organisms != null) {
			organisms.setSelfUri(requestUri);
			
			for(Organism organism : organisms) {
				fillLinks(organism, requestUri);
				fillRelatedLinks(organism);
			}
		}
	}
	
	public void fillLinks(OrganismGroups organismGroups, URI requestUri) {
		if(organismGroups != null) {
			organismGroups.setSelfUri(requestUri);
			
			for(OrganismGroup organismGroup : organismGroups) {
				fillLinks(organismGroup, requestUri);
				fillRelatedLinks(organismGroup);
			}
		}
	}
	
	public void fillLinks(Organism organism, URI requestUri) {
		URI selfUri = UriBuilder.fromUri(baseUri).path("public").path("antibiogram").path("facility").path(organism.getFacilitySiteCode()).path("organism").path(organism.getId()).build();
		organism.setSelfUri(selfUri);
	}

	public void fillRelatedLinks(Organism organism) {
		URI antibioticUri = UriBuilder.fromUri(organism.getSelfUri()).path("antibiotic").build();
		organism.getLink().addRelatedLink("antibiotics", antibioticUri);
	}
	
	public void fillLinks(OrganismGroup organismGroup, URI requestUri) {
		URI selfUri = UriBuilder.fromUri(baseUri).path("public").path("antibiogram").path("facility").path(organismGroup.getFacilityCode()).path("organism-group").path(organismGroup.getId()).build();
		organismGroup.setSelfUri(selfUri);
	}
	
	public void fillRelatedLinks(OrganismGroup organismGroup) {
		URI antibioticUri = UriBuilder.fromUri(organismGroup.getSelfUri()).path("antibiotic").build();
		organismGroup.getLink().addRelatedLink("antibiotics", antibioticUri);
	}
		
	
}
