
package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.Admissions;
import com.agilex.healthcare.utility.DateHelper;

public class AdmissionLinkBuilder extends AbstractSimplePatientDataLinkBuilder<Admissions, Admission> {

	public AdmissionLinkBuilder(URI baseUri) {
		super(baseUri);
		this.setIncludeCommunityIn      icalSelfUri(true);
	}

	@Override
	protected String getDomainSpecificPath() {
		return "admissions";
	}
	
	@Override
	protected void fillCustomRelatedLinks(Admission admission) {
		if(admission.getAdmissionDate() != null && admission.getDischargeDate() != null) {
			String admissionDate = DateHelper.formatDate(admission.getAdmissionDate());
			String dischargeDate = DateHelper.formatDate(admission.getDischargeDate());

			URI dischargeNoteLink = UriBuilder.fromUri(admission.getSelfUri()).path("note").queryParam("startDate", admissionDate).queryParam("endDate", dischargeDate).build();
			admission.getLink().addRelatedLink("notes", dischargeNoteLink);
		}
		
		super.fillCustomRelatedLinks(admission);
	}

}
