package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.utility.NullChecker;

public abstract class AbstractSimplePatientDataLinkBuilder<Ts extends PatientDataCollection<T>, T extends PatientData> extends PatientDataLinkBuilder<Ts, T> {

	private boolean includeCommunityIn      icalSelfUri = false;

	public AbstractSimplePatientDataLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(T dataItem) {
		URI selfUri = null;
		String domainSpecificPath = getDomainSpecificPath();
		if (NullChecker.isNotNullish(domainSpecificPath)) {
			URI patientUri = this.extractPatientUri(dataItem);
			if (shouldIncludeCommunityIn      icalSelfUri()) {
				selfUri = UriBuilder.fromUri(get      icalUriForCollection(patientUri)).path("system").path(dataItem.getDataIdentifier().getSystemId()).path("id").path(dataItem.getUniqueId()).build();
			} else {
				selfUri = UriBuilder.fromUri(get      icalUriForCollection(patientUri)).path("id").path(dataItem.getUniqueId()).build();
			}
		}
		return selfUri;
	}

	protected boolean shouldIncludeCommunityIn      icalSelfUri() {
		return this.includeCommunityIn      icalSelfUri;
	}

	protected void setIncludeCommunityIn      icalSelfUri(boolean includeCommunityIn      icalSelfUri) {
		this.includeCommunityIn      icalSelfUri = includeCommunityIn      icalSelfUri;
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return UriBuilder.fromUri(patientUri).path(getDomainSpecificPath()).build();
	}

	protected abstract String getDomainSpecificPath();

	@Override
	protected void fillCustomRelatedLinks(T dataItem) {
		// assume no custom related links,
		// sub class can still override if needed
	}

	@Override
	protected void fillCustomRelatedLinks(Ts dataList) {
		// assume no custom related links,
		// sub class can still override if needed
	}

}
