package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;

public abstract class AbstractPatientDataLinkBuilderWithNoSelfLink<Ts extends PatientDataCollection<T>, T extends PatientData> extends PatientDataLinkBuilder<Ts, T> {

	public AbstractPatientDataLinkBuilderWithNoSelfLink(URI baseUri) {
		super(baseUri);
	}

	@Override
	public void fillLinks(T dataItem, URI requestUri) {
		fillCustomRelatedLinks(dataItem);
	};

	@Override
	public URI get      icalSelfUri(T dataItem) {
		return null;
	};

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return UriBuilder.fromUri(patientUri).path(getDomainSpecificPath()).build();
	}

	protected abstract String getDomainSpecificPath();

}
