package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import java.net.URI;

import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.utility.NullChecker;

public class UriDtoValidator {
	public static void validate(PatientDataCollection<?> patientDataCollection) {
		if (patientDataCollection == null)
			throw new IllegalArgumentException("Cannot create URI for null collection object");
	}

	public static void validate(PatientData dto) {
		if (dto == null)
			throw new IllegalArgumentException("Cannot create URI for null object");
		validate(dto.getPatientIdentifier());
		validate(dto.getDataIdentifier());
	}

	private static void validate(DataIdentifier identifier) {
		if (identifier == null)
			throw new IllegalArgumentException("Cannot create URI for object without identifier");
		if (!isValid(identifier.getUniqueId()))
			throw new IllegalArgumentException("Cannot create URI for object without identifier");
	}

	private static void validate(PatientIdentifier identifier) {
		if (identifier == null)
			throw new IllegalArgumentException("Cannot create URI for object without patient identifier");
		if (!isValid(identifier.getUniqueId()) || !isValid(identifier.getAssigningAuthority()))
			throw new IllegalArgumentException("Cannot create URI for object without patient identifier");
	}

	private static boolean isValid(String string) {
		return NullChecker.isNotNullish(string);
	}

	public static void validate(URI uri) {
		validate(uri, "");
	}

	public static void validate(URI uri, String failedValidationMessage) {
		if (uri == null || NullChecker.isNullish(uri.toString()))
			throw new IllegalArgumentException("Invalid URI");
	}

	public static void validate(Patient patient) {
		if (patient == null)
			throw new IllegalArgumentException("Cannot create URI for null patient");
		validate(patient.getPatientIdentifier());
	}

	public static void validate(Patients patients) {
		if (patients == null) {
			throw new IllegalArgumentException("Cannot create URI for null patient list");
		}
	}

}
