package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import java.net.URI;

import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.PatientLinkBuilder;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.patient.PatientUriBuilder;

public class PatientUriHelper {
	private static PatientUriBuilder uriBuilder = new PatientUriBuilder();

	/**
	 * @deprecated Please use {@link PatientLinkBuilder}
	 * 
	 */
	@Deprecated
	public static void updatePatientsLinks(PatientSearchResults patients, UriInfo resourceUriInfo) {
		uriBuilder.updatePatientSearchResultsLinks(patients, resourceUriInfo.getRequestUri(), resourceUriInfo.getBaseUri());
	}

	/**
	 * @deprecated Please use {@link PatientLinkBuilder}
	 * 
	 */
	public static void updatePatientLinks(Patient patient, URI baseURI) {
		uriBuilder.updatePatientLinks(patient, baseURI);
	}

	public static URI createPatientSelfUri(PatientData patientData, URI baseUri) {
		if (patientData == null)
			return null;
		return createPatientSelfUri(patientData.getPatientIdentifier(), baseUri);
	}

	public static URI createPatientSelfUri(Patient patient, URI baseUri) {
		URI uri = null;
		if (patient == null)
			uri = null;
		else
			uri = createPatientSelfUri(patient.getPatientIdentifier(), baseUri);
		return uri;
	}

	public static URI createPatientSelfUri(PatientIdentifier patientIdentifier, URI baseUri) {
		return uriBuilder.createPatientSelfUri(patientIdentifier, baseUri);
	}

	public static void updateDemographicsLinks(PatientIdentifier patientId, PatientDemographics extendedData, URI baseURI) {
		URI patientUri = createPatientSelfUri(patientId, baseURI);

		URI selfUri = UriHelper.mergeUri(patientUri, "demographics");
		extendedData.setSelfUri(selfUri);
	}

}
