package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.NotificationUser;
import com.agilex.healthcare.mobilehealthplatform.domain.NotificationUsers;

public class NotificationUserUriHelper {

	public static void updateNotificationUsersLinks(NotificationUsers notificationUsers, UriInfo uriInfo) {
		if(notificationUsers != null) {
			for (NotificationUser notificationUser : notificationUsers) {
				updateNotificationUserLinks(notificationUser, uriInfo);
			}
		}
	}

	private static void updateNotificationUserLinks(NotificationUser notificationUser, UriInfo uriInfo) {
		if(notificationUser != null) {
			String userId = notificationUser.getUserId();
			URI uri = UriBuilder.fromUri(uriInfo.getBaseUri()).path("notification-service").path("user").path("id").path("EDIPI").path(userId).path("notifications").build();
			notificationUser.getLink().addRelatedLink(LinkTitles.UserNotifications, uri);
			
			URI auditUri = UriBuilder.fromUri(uriInfo.getBaseUri()).path("notification-service").path("audits").path("auditLogs").path("user").path("id").path("EDIPI").path(userId).build();
			notificationUser.getLink().addRelatedLink(LinkTitles.UserNotificationAuditLogs, auditUri);
		}
	}

}
