package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.mobilehealthplatform.domain.Notification;
import com.agilex.healthcare.mobilehealthplatform.domain.Notifications;

public class NotificationUriHelper {

	public static void updateNotificationsLinks(Notifications notifications, UriInfo uriInfo) {
		if(notifications != null && uriInfo != null) {
			for (Notification notification : notifications) {
				updateNotificationLinks(notification, uriInfo);
			}
		}
	}

	public static void updateNotificationLinks(Notification notification, UriInfo uriInfo) {
		if(notification != null && uriInfo != null) {
			String notificationId = notification.getNotificationId();
			String userId = notification.getUserId();
			URI selfUri = UriBuilder.fromUri(uriInfo.getBaseUri()).path("notification-service").path("users").path("id").path(userId).path("notifications").path("id").path(notificationId).build();
			notification.setSelfUri(selfUri);
		}
	}

}
