package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroup;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.utility.NullChecker;

@Deprecated
public class MicrobiologyLabUriHelper {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MicrobiologyLabUriHelper.class);

	public static void updateLabTestsLinks(LabTests labTests, PatientIdentifier patientId, UriInfo uriInfo) {
		logger.debug("building links for labTests");
		if (labTests != null) {
			labTests.setSelfUri(uriInfo.getRequestUri());

			for (LabTest labTest : labTests) {
				updateLabTestLinks(labTest, patientId, uriInfo);
			}
		}
	}

	private static void updateLabTestLinks(LabTest labTest, PatientIdentifier patientIdentifier, UriInfo uriInfo) {
		URI labResultsForTestLink = createUriLabResultsForTest(uriInfo.getBaseUri(), patientIdentifier, labTest);
		labTest.setLabResultsForTestUri(labResultsForTestLink);

		updateLabResultsLinks(labTest.getLabResults(), patientIdentifier, uriInfo);
	}

	public static void updateLabResultsLinks(LabResults labResults, PatientIdentifier patientIdentifier, UriInfo uriInfo) {
		logger.debug("building links for results");
		if (labResults != null) {
			labResults.setSelfUri(uriInfo.getRequestUri());
			for (LabResult labResult : labResults) {
				updateLabResultLinks(labResult, patientIdentifier, uriInfo);
			}
		}
	}

	public static void updateLabResultLinks(LabResult labResult, PatientIdentifier patientIdentifier, UriInfo uriInfo) {
		URI patientUri = PatientUriHelper.createPatientSelfUri(patientIdentifier, uriInfo.getBaseUri());
		URI selfUri = UriBuilder.fromUri(patientUri).path("lab-microbiology").path("results").path("system").path(labResult.getDataIdentifier().getSystemId()).path("id").path(labResult.getUniqueId()).build();
		labResult.setSelfUri(selfUri);
	}

	private static URI createUriLabResultsForTest(URI baseUri, PatientIdentifier patientIdentifier, LabTest labTest) {
		URI patientUri = PatientUriHelper.createPatientSelfUri(patientIdentifier, baseUri);
		URI uri = null;
		if ((labTest != null) && (NullChecker.isNotNullish(labTest.getUniqueId())) && NullChecker.isNotNullish(labTest.getSpecimenId())) {
			uri = UriBuilder.fromUri(patientUri).path("lab-microbiology").path("results").queryParam("test-id", labTest.getUniqueId()).queryParam("specimenId", labTest.getSpecimenId()).build();
		} else if ((labTest != null) && (NullChecker.isNotNullish(labTest.getUniqueId()))) {
			uri = UriBuilder.fromUri(patientUri).path("lab-microbiology").path("results").queryParam("test-id", labTest.getUniqueId()).build();
		}

		return uri;
	}

	public static void updateLabTestsLinks(LabTestGroups labTestGroups, PatientIdentifier patientId, UriInfo uriInfo) {
		logger.debug("building links for labTests");

		if (labTestGroups != null) {
			labTestGroups.setSelfUri(uriInfo.getRequestUri());

			for (LabTestGroup labgroup : labTestGroups) {
				LabTests labTests = labgroup.getLabTests();

				for (LabTest labTest : labTests) {
					updateLabTestLinks(labTest, patientId, uriInfo);
				}
			}
		}

	}

}
