package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroup;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.utility.NullChecker;

@Deprecated
public class LabUriHelper {
	private LabUriHelper() {
	}

	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(LabUriHelper.class);

	public static void updateLabTestsLinks(LabTests labTests, PatientIdentifier patientId, UriInfo uriInfo) {
		logger.debug("building links for labTests");
		if (labTests != null) {
			labTests.setSelfUri(uriInfo.getRequestUri());

			for (LabTest labTest : labTests) {
				updateLabTestLinks(labTest, patientId, uriInfo);
			}
		}
	}

	private static void updateLabTestLinks(LabTest labTest, PatientIdentifier patientId, UriInfo uriInfo) {
		URI labResultsForTestLink = createUriLabResultsForTest(uriInfo.getBaseUri(), patientId, labTest);
		labTest.setLabResultsForTestUri(labResultsForTestLink);

		// updateLabResultLinks(labTest.getMostRecentLabResult(),patientId,
		// uriInfo);
	}

	public static void updateLabResultsLinks(LabResults results, PatientIdentifier patientIdentifier, UriInfo uriInfo) {
		logger.debug("building links for results");
		if (results != null) {
			results.setSelfUri(uriInfo.getRequestUri());

			// for (LabResult result : results) {
			// updateLabResultLinks(result,patientId, uriInfo);
			// }
		}
	}

	// private static void updateLabResultLinks(LabResult result,String
	// patientId, UriInfo uriInfo) {
	// URI resultUri = createLabResultUri(uriInfo.getBaseUri(),patientId,
	// result);
	// result.setSelfUri(resultUri);
	// }

	// private static URI createLabResultUri(URI baseUri, String patientId,
	// LabResult result) {
	// URI patientUri = PatientUriHelper.createPatientSelfUri(patientId,
	// baseUri);
	// URI uri = null;
	// if (NullChecker.isNotNullish(result.getOrderId()))
	// uri =
	// UriBuilder.fromUri(patientUri).path("lab").path("order").path(result.getOrderId()).path("results").build();
	// return uri;
	// }

	private static URI createUriLabResultsForTest(URI baseUri, PatientIdentifier patientIdentifier, LabTest labTest) {
		URI patientUri = PatientUriHelper.createPatientSelfUri(patientIdentifier, baseUri);
		URI uri = null;
		if ((labTest != null) && (NullChecker.isNotNullish(labTest.getUniqueId())) && NullChecker.isNotNullish(labTest.getSpecimenId())) {
			uri = UriBuilder.fromUri(patientUri).path("lab").path("results").path("system").path(labTest.getDataIdentifier().getSystemId()).queryParam("test-id", labTest.getUniqueId()).queryParam("specimenId", labTest.getSpecimenId()).build();
		} else if ((labTest != null) && (NullChecker.isNotNullish(labTest.getUniqueId()))) {
			uri = UriBuilder.fromUri(patientUri).path("lab").path("results").path("system").path(labTest.getDataIdentifier().getSystemId()).queryParam("test-id", labTest.getUniqueId()).build();
		}

		return uri;
	}

	public static void updateLabTestsLinks(LabTestGroups labTestGroups, PatientIdentifier patientId, UriInfo uriInfo) {

		logger.debug("building links for labTests");

		if (labTestGroups != null) {
			labTestGroups.setSelfUri(uriInfo.getRequestUri());

			for (LabTestGroup labgroup : labTestGroups) {

				LabTests labTests = labgroup.getLabTests();

				for (LabTest labTest : labTests) {
					updateLabTestLinks(labTest, patientId, uriInfo);
				}

			}
		}

	}

}
