package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.mobilehealthplatform.domain.DeviceRegistration;
import com.agilex.healthcare.mobilehealthplatform.domain.DeviceRegistrations;

public class DeviceRegistrationUriHelper {

	public static void updateDeviceRegistrationsLinks(DeviceRegistrations deviceRegistrations, UriInfo uriInfo) {
		if(deviceRegistrations != null && uriInfo != null) {
			for (DeviceRegistration deviceRegistration : deviceRegistrations) {
				updateDeviceRegistrationLinks(deviceRegistration, uriInfo);
			}
		}
	}

	public static void updateDeviceRegistrationLinks(DeviceRegistration deviceRegistration, UriInfo uriInfo) {
		if(deviceRegistration != null && uriInfo != null) {
			String userId = deviceRegistration.getUserId();
			String deviceToken = deviceRegistration.getDeviceToken();
			URI selfUri = UriBuilder.fromUri(uriInfo.getBaseUri()).path("notification-service").path("user").path("id").path("EDIPI").path(userId).path("device-registrations").path("token").path(deviceToken).build();
			deviceRegistration.setSelfUri(selfUri);
		}
	}
}
