package com.agilex.healthcare.mobilehealthplatform.utils;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import com.agilex.healthcare.utility.NullChecker;

import edu.emory.mathcs.backport.java.util.Arrays;

@Component(value="pilotFacilitiesHelper")
public class PilotFacilitiesHelper {
	
	@Resource
	PropertyHelper propertyHelper;
	
	public List<String> getPilotSites() {
		return getPilotSites(null);
	}
	
	@SuppressWarnings("unchecked")
	public List<String> getPilotSites(String appName) {
		List<String> pilotSitesList = null;
		
		String key = null;
		if (NullChecker.isNotNullish(appName)) {
			key = String.format("facilities.%s.pilotSites", appName.toLowerCase().trim());
		}
		
		if (key != null) {
			String pilotSites = propertyHelper.getProperty(key);
			
			if (NullChecker.isNotNullish(pilotSites)) {
				String[] pilotSitesArray = pilotSites.split(",");
				pilotSitesList = (List<String>)Arrays.asList(pilotSitesArray);
			}
		}
		
		return pilotSitesList;
	}
}
