package com.agilex.healthcare.mobilehealthplatform.utils;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchPaging;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.utility.NullChecker;

public class Paging {
	public Patients enforceMaxRecords(Patients patients, PatientSearchPaging pagingInfo) {
		Patients result = patients;
		if (maxRecordsWasSupplied(pagingInfo)) {
			if (validPageNumberWasSupplied(pagingInfo))
				defaultPageNumberToFirstPage(pagingInfo);

			if (NullChecker.isNotNullish(patients)) {
				int startIndex = determineFirstPatient(pagingInfo);
				int endIndex = determineLastPatient(patients, pagingInfo, startIndex);
				if (noMorePatients(startIndex, endIndex)) {
					result = new Patients();
				} else if (noMorePatientsLeftForThisPage(patients, startIndex, endIndex)) {
					// just use original patients
				} else {
					result = trimPatientsList(patients, startIndex, endIndex) ;
				}
			}
		}
		return result;
	}

	private boolean noMorePatients(int startIndex, int endIndex) {
		return startIndex > endIndex;
	}

	private Patients trimPatientsList(Patients patients, int startIndex, int endIndex) {
		List<Patient> list = patients.subList(startIndex, endIndex);
		Patients temp = new Patients();
		temp.addAll(list);
		return temp;
	}

	private boolean noMorePatientsLeftForThisPage(Patients patients, int startIndex, int endIndex) {
		return startIndex == 0 && endIndex == patients.getSize();
	}
	private int determineLastPatient(Patients patients, PatientSearchPaging pagingInfo, int startIndex) {
		return Math.min(patients.getSize(), startIndex + pagingInfo.getMaxRecords());
	}

	private int determineFirstPatient(PatientSearchPaging pagingInfo) {
		return (pagingInfo.getPageNumber() - 1) * pagingInfo.getMaxRecords();
	}

	private void defaultPageNumberToFirstPage(PatientSearchPaging pagingInfo) {
		pagingInfo.setPageNumber(1);
	}

	private boolean validPageNumberWasSupplied(PatientSearchPaging pagingInfo) {
		return NullChecker.isNullish(pagingInfo.getPageNumber());
	}

	private boolean maxRecordsWasSupplied(PatientSearchPaging pagingInfo) {
		return (pagingInfo != null) && (NullChecker.isNotNullish(pagingInfo.getMaxRecords()));
	}

}
