package com.agilex.healthcare.mobilehealthplatform.utils;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class DefaultAssigningAuthorityUpdater {
	public static void fillDefaultAssigningAuthority(Patients patients, String assigningAuthority) {
		if (patients != null) {
			for (Patient patient : patients) {
				fillDefaultAssigningAuthority(patient, assigningAuthority);
			}
		}
	}

	public static void fillDefaultAssigningAuthority(Patient patient, String assigningAuthority) {
		if (patient != null) {
			patient.getPatientIdentifier().setAssigningAuthority(assigningAuthority);
		}
	}

	public static void fillDefaultAssigningAuthority(PatientData data, String assigningAuthority) {
		if (data != null) {
			data.getPatientIdentifier().setAssigningAuthority(assigningAuthority);
		}
	}
}
