package com.agilex.healthcare.mobilehealthplatform.tooltrackingresult;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import org.apache.log4j.Logger;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataEditRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResult;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResults;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class ToolTrackingResultDataService {
	private static final Logger logger = Logger.getLogger(ToolTrackingResultDataService.class);
	private Router router;

	public ToolTrackingResultDataService() {
		this.router = new Router();
	}

	public ToolTrackingResultDataService(Router router) {
		this.router = router;
	}

	public ToolTrackingResults fetchResults(PatientIdentifier patientIdentifier) {
        return fetchResults(patientIdentifier, DateFilterFactory.createEmptyFilter());
	}

    public ToolTrackingResults fetchResults(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
        logger.debug("Fetching all ToolTrackingResults for patient");

        RequestMessage request = ToolTrackingFetchRequestBuilder.forFetchList().forDomain(Domain.toolTrackingResult).forPatientIdentifier(patientIdentifier).forDateFilter(dateFilter).forScopeFilter(ScopeFilter.getInstanceForLongitudinalScope()).build();
        ResponseMessage response = router.execute(request);
        ToolTrackingResults results = PatientDataResponseReader.<ToolTrackingResults, ToolTrackingResult> fromResponse(response).getDataListNoNull(ToolTrackingResults.class);

        return results;
    }

    public ToolTrackingResult fetchMostRecentResult(PatientIdentifier patientIdentifier, String tool) {
		logger.debug("Fetching Most Recent ToolTrackingResult for patient");

		DataIdentifier workaroundIdentifier = new DataIdentifier(null, tool);
		RequestMessage request = ToolTrackingFetchRequestBuilder.forFetchMostRecent().forDomain(Domain.toolTrackingResult).forPatientIdentifier(patientIdentifier).forDataIdentifier(workaroundIdentifier).forScopeFilter(ScopeFilter.getInstanceForLongitudinalScope()).build();
		ResponseMessage response = router.execute(request);
		ToolTrackingResult result = PatientDataResponseReader.<ToolTrackingResults, ToolTrackingResult> fromResponse(response).getDataItem();

		return result;
	}

	public ToolTrackingResult fetchResult(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier) {
		logger.debug("Fetching Specific ToolTrackingResult for patient]");

		RequestMessage requestMessage = ToolTrackingFetchRequestBuilder.forFetchSingle().forDomain(Domain.toolTrackingResult).forPatientIdentifier(patientIdentifier).forDataIdentifier(dataIdentifier).forScopeFilter(ScopeFilter.getInstanceForLongitudinalScope()).build();
		ResponseMessage response = router.execute(requestMessage);
		ToolTrackingResult result = PatientDataResponseReader.<ToolTrackingResults, ToolTrackingResult> fromResponse(response).getDataItem();

		return result;
	}

	public ToolTrackingResult save(ToolTrackingResult result) {
		logger.debug("Saving ToolTrackingResult for patient");

		RequestMessage requestMessage = PatientDataEditRequestBuilder.forCreate().forDomain(Domain.toolTrackingResult).forData(result).forPatientIdentifier(result.getPatientIdentifier()).forScope(ScopeFilter.getInstanceForLongitudinalScope()).build();
		ResponseMessage response = router.execute(requestMessage);
		ToolTrackingResult savedResult = PatientDataResponseReader.<ToolTrackingResults, ToolTrackingResult> fromResponse(response).getDataItem();

		return savedResult;
	}

	public ToolTrackingResult update(ToolTrackingResult result) {
		logger.debug("Updating ToolTrackingResult for patient");

		RequestMessage requestMessage = PatientDataEditRequestBuilder.forUpdate().forDomain(Domain.toolTrackingResult).forData(result).forPatientIdentifier(result.getPatientIdentifier()).forScope(ScopeFilter.getInstanceForLongitudinalScope()).build();
		ResponseMessage response = router.execute(requestMessage);
		ToolTrackingResult updatedResult = PatientDataResponseReader.<ToolTrackingResults, ToolTrackingResult> fromResponse(response).getDataItem();

		return updatedResult;
	}

	public void delete(ToolTrackingResult result) {
		logger.debug("Deleting ToolTrackingResult for patient");

		RequestMessage request = PatientDataEditRequestBuilder.forDelete().forDomain(Domain.toolTrackingResult).forData(result).forPatientIdentifier(result.getPatientIdentifier()).forScope(ScopeFilter.getInstanceForLongitudinalScope()).build();
		router.execute(request);
	}
}
