package com.agilex.healthcare.mobilehealthplatform.tooltrackingresult;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.*;

import java.util.Collection;

public class ToolTrackingRequestHandlerHelper{

    private static Collection<DataSystem> determineDataSystemList() {
        DomainServiceRegistry registry = new DomainServiceRegistry();
        return registry.getDataSystems(ScopeFilter.getInstanceForLongitudinalScope(), Domain.toolTrackingResult);
    }

    public static PatientIdentifier translatePatientIdentifier(PatientDataFetchRequestReader requestReader) {
        Collection<DataSystem> dataSystems = determineDataSystemList();

        for(DataSystem targetDataSystem : dataSystems) {
            PatientIdentifiers correspondingIdentifiers = MhpObjectFactory.getInstance().getPatientCorrelationService().getCorrespondIdentifiers(requestReader.getPatientIdentifier(), targetDataSystem.getPatientAssigningAuthority());
            for(PatientIdentifier userIdentifier : correspondingIdentifiers) {
                return userIdentifier;
            }
        }

        return requestReader.getPatientIdentifier();
    }

}
