package com.agilex.healthcare.mobilehealthplatform.tooltrackingresult;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class ToolTrackingFetchRequestBuilder extends PatientDataFetchRequestBuilder {
	protected RequestMessage requestMessage;
	
	public ToolTrackingFetchRequestBuilder(RequestMessage request) {
		super(request);
	}
	
	public static ToolTrackingFetchRequestBuilder forFetchList() {
		RequestMessage request = new RequestMessage();
		ToolTrackingFetchRequestBuilder builder = new ToolTrackingFetchRequestBuilder(request);
		request.setType("FetchToolTrackingResults");
		return builder;
	}
	
	public static ToolTrackingFetchRequestBuilder forFetchMostRecent() {
		RequestMessage request = new RequestMessage();
		ToolTrackingFetchRequestBuilder builder = new ToolTrackingFetchRequestBuilder(request);
		request.setType("FetchMostRecentToolTrackingResult");
		return builder;
	}
	
	public static ToolTrackingFetchRequestBuilder forFetchSingle() {
		RequestMessage request = new RequestMessage();
		ToolTrackingFetchRequestBuilder builder = new ToolTrackingFetchRequestBuilder(request);
		request.setType("FetchToolTrackingResult");
		return builder;
	}
	
	public ToolTrackingFetchRequestBuilder forTool(String tool) {
		request.setValue("tool", tool);
		return this;
	}
	
	public ToolTrackingFetchRequestBuilder forDomain(String domain) {
		super.forDomain(domain);
		return this;
	}
	
	public ToolTrackingFetchRequestBuilder forPatientIdentifier(PatientIdentifier patientIdentifier) {
		super.forPatientIdentifier(patientIdentifier);
		return this;
	}
	
	public ToolTrackingFetchRequestBuilder forDataIdentifier(DataIdentifier dataIdentifier) {
		super.forDataIdentifier(dataIdentifier);
		return this;
	}
}
