package com.agilex.healthcare.mobilehealthplatform.tooltrackingresult;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.tooltrackingresult.ToolTrackingResultDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResult;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResults;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;

public class FetchToolTrackingResultsRequestHandler extends AbstractFetchPatientDataListRequestHandler<ToolTrackingResultDataLayer, ToolTrackingResults, ToolTrackingResult> {

	@Override
	protected ToolTrackingResults invokeDataLayerToFetchList(ToolTrackingResultDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
        PatientIdentifier patientIdentfier = ToolTrackingRequestHandlerHelper.translatePatientIdentifier(messageReader);

        DateFilter dateFilter = messageReader.getDateFilter();
        if (dateFilter == null){
            dateFilter = DateFilterFactory.createEmptyFilter();
        }
            return datalayer.fetchItems(patientIdentfier.getUniqueId(), messageReader.getDateFilter());
	}
}
