package com.agilex.healthcare.mobilehealthplatform.tooltrackingresult;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.tooltrackingresult.ToolTrackingResultDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResult;

public class FetchToolTrackingResultRequestHandler extends AbstractFetchPatientDataRequestHandler<ToolTrackingResultDataLayer, ToolTrackingResult> {

	@Override
	protected ToolTrackingResult invokeDataLayerToFetchSingleItem(ToolTrackingResultDataLayer datalayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage) {
		ToolTrackingResult fetchedItem = datalayer.fetchItem(patientIdentifier.getUniqueId(), dataId);
		fetchedItem.setPatientIdentifier(patientIdentifier);
		return fetchedItem;
	}

}
