package com.agilex.healthcare.mobilehealthplatform.tooltrackingresult;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.tooltrackingresult.ToolTrackingResultDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResult;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public class FetchMostRecentToolTrackingResultRequestHandler implements RequestHandler {

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		PatientDataFetchRequestReader requestReader = PatientDataFetchRequestReader.fromRequest(requestMessage);
		
		PatientIdentifier translatedIdentifier = ToolTrackingRequestHandlerHelper.translatePatientIdentifier(requestReader);
		ToolTrackingResultDataLayer dataLayer = getDataLayer(requestMessage);
		
		ToolTrackingResult result = invokeDataLayer(dataLayer, translatedIdentifier, requestReader.getDataIdentifier());
		
		if(result != null)
			result.setPatientIdentifier(translatedIdentifier);
		
		return PatientDataResponseBuilder.fromPatientData(result).build();
	}
	
	private ToolTrackingResultDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
	
	ToolTrackingResult invokeDataLayer(ToolTrackingResultDataLayer dataLayer, PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier) {
		return dataLayer.fetchMostRecentItem(patientIdentifier.getUniqueId(), dataIdentifier.getUniqueId());	
	}
	
}
