package com.agilex.healthcare.mobilehealthplatform.serviceregistry;

public class SystemsDataLayerFactory<T> {
	private DataSystem datasystem;
	private T datalayer;

	public static <T> SystemsDataLayerFactory<T> getInstance(T datalayer, DataSystem datasystem) {
		SystemsDataLayerFactory<T> datalayerfactory = new SystemsDataLayerFactory<T>();
		datalayerfactory.datasystem = datasystem;
		datalayerfactory.datalayer = datalayer;
		return datalayerfactory;
	}

	public T getDataLayerInstance() {
		return datalayer;
	}

	public DataSystem getDataSystem() {
		return datasystem;
	}
}
