package com.agilex.healthcare.mobilehealthplatform.serviceregistry;

import java.util.HashMap;
import java.util.List;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import com.agilex.healthcare.mobilehealthplatform.datalayer.UserLastAccessedTimeDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.admission.AdmissionDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.antibiogram.AntibiogramDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentMetricsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentRequestDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentRequestInProcessDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.DetailCodeDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.assessment.AssessmentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.audit.AuditLogDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.calendar.CalendarEventDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.calendar.CalendarKeyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.contactlog.ContactLogDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dailyevents.DailyEventDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.diet.DietDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.exercise.ExerciseDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityInternalDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.feedback.UserFeedbackDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.ChemistryLabDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro.MicrobiologyLabDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.launchpad.LaunchpadItemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.learn.LearnDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.mood.MoodEventDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals.MygoalsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.DeviceRegistrationDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationCommunicationDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientInternalDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientMetadataDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.preference.PatientPreferenceDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.radiology.RadiologyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.rightofaccess.RightOfAccessDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage.SecureMessageDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.staffdirectory.StaffDirectoryDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer.StaffUserDisclaimerDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.surgery.SurgeryDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroup;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationService;
import com.agilex.healthcare.utility.NullSafeStringComparer;
import com.agilex.healthcare.vamf.cdw.allergy.CdwAllergyDataLayer;
import com.agilex.healthcare.vamf.cdw.appointment.CdwAppointmentDataLayer;
import com.agilex.healthcare.vamf.cdw.chemlabs.CdwChemistryLabDataLayer;
import com.agilex.healthcare.vamf.cdw.facilities.CdwFacilityDataLayer;
import com.agilex.healthcare.vamf.cdw.medication.CdwMedicationDataLayer;
import com.agilex.healthcare.vamf.cdw.problems.CdwProblemDataLayer;
import com.agilex.healthcare.vamf.cdw.radiology.CdwRadiologyDataLayer;
import com.agilex.healthcare.vamf.cdw.surgery.CdwSurgeryDataLayer;
import com.agilex.healthcare.vamf.cdw.vitals.CdwVitalsDataLayer;
import com.agilex.system.health.HealthCheckRunner;

public class MhpObjectFactory implements DataLayerFactory, ApplicationContextAware {

    private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(MhpObjectFactory.class);

	private static final String PATIENTDATALAYER_BEAN = "patientDataLayer";
	private static final String PROBLEMDATALAYER_BEAN = "problemDataLayer";
	private static final String ALLERGYDATALAYER_BEAN = "allergyDataLayer";
	private static final String MEDICATIONDATALAYER_BEAN = "medicationDataLayer";
	private static final String MEDICATIONREFILLDATALAYER_BEAN = "medicationRefillDataLayer";
	private static final String CHEMISTRYLABDATALAYER_BEAN = "chemistryLabDataLayer";
	private static final String MICROBIOLOGYLABDATALAYER_BEAN = "microbiologyLabDataLayer";
	private static final String CHEMISTRY_LAB_GROUP_DEFINITION_BEAN = "chemistryLabGroupDefinitions";
	private static final String HEALTHCHECKCOMPONENT = "healthCheckComponent";
	private static final String VITALDATALAYER_BEAN = "vitalDataLayer";
	private static final String VITALPROVIDERDATALAYER_BEAN = "vitalProviderDataLayer";
	private static final String DIETDATALAYER_BEAN = "dietDataLayer";
	private static final String CONTACTLOGDATALAYER_BEAN = "contactLogDataLayer";
	private static final String APPOINTMENTSDATALAYER_BEAN = "appointmentsDataLayer";
	private static final String APPOINTMENTREQUESTDATALAYER_BEAN = "appointmentRequestDataLayer";
	private static final String ADMISSIONDATALAYER_BEAN = "admissionDataLayer";
	private static final String SURGERYDATALAYER_BEAN = "surgeryDataLayer";
	private static final String RADIOLOGYDATALAYER_BEAN = "radiologyDataLayer";
	private static final String MOODEVENTDATALAYER_BEAN = "moodEventDataLayer";
	private static final String DAILYEVENTDATALAYER_BEAN = "dailyEventDataLayer";
	private static final String EXERCISEDATALAYER_BEAN = "exerciseDataLayer";
	private static final String DOCUMENTDATALAYER_BEAN = "documentDataLayer";
	private static final String NOTIFICATIONDATALAYER_BEAN = "notificationDataLayer";
	private static final String NOTIFICATIONCOMMUNICATIONDATALAYER_BEAN = "notificationCommunicationDataLayer";
	private static final String DEVICEREGISTRATIONDATALAYER_BEAN = "deviceRegistrationDataLayer";
	private static final String CALENDARKEYDATALAYER_BEAN = "calendarKeyDataLayer";
	private static final String SECUREMESSAGEDATALAYER_BEAN = "secureMessageDataLayer";
	private static final String CALENDAR_EVENT_DATALAYER_BEAN = "calendarEventDataLayer";
	private static final String RIGHT_OF_ACCESS_BEAN = "rightOfAccessDataLayer";
	private static final String AUDIT_LOG_BEAN = "auditLogDataLayer";
	private static final String ASSESSMENT_DATALAYER_BEAN = "assessmentDataLayer";
	private static final String LEARN_DATALAYER_BEAN = "learnDataLayer";
	private static final String PATIENT_CORRELATION_BEAN = "patient-correlation";
	private static final String USERFEEDBACK_DATALAYER_BEAN = "userFeedbackDataLayer";
	private static final String PATIENT_METADATA_DATALAYER_BEAN = "patientMetadataDataLayer";
	private static final String FACILITY_DATALAYER_BEAN = "facilityDataLayer";
	private static final String DETAIL_CODE_DATALAYER = "detailCodeDataLayer";
	private static final String FACILITY_INTERNAL_DATALAYER = "facilityInternalDataLayer";
	private static final String PATIENT_INTERNAL_DATALAYER = "patientInternalDataLayer";
	private static final String APPOINTMENT_METRICS_DATALAYER = "appointmentMetricsDataLayer";
	private static final String APPOINTMENTREQUESTINPROCESS_DATALAYER = "appointmentRequestInProcessDataLayer";
	private static final String METRIC_DATALAYER = "metricDataLayer";
	private static final String LAUNCHPAD_ITEM_DATALAYER = "launchpadItemDataLayer";
	private static final String INVENTORY_DATALAYER = "inventoryDataLayer";
	private static final String PATIENT_PREFERENCE_DATALAYER = "patientPreferenceDataLayer";
	private static final String ANTIBIOGRAM_DATALAYER = "antibiogramDataLayer";
	private static final String STAFF_USER_DISCLAIMER_DATALAYER = "staffUserDisclaimerDataLayer";
	private static final String STAFF_DIRECTORY_DATALAYER = "staffDirectoryDataLayer";
	private static final String USER_LAST_ACCESSED_TIME_DATALAYER = "userLastAccessedTimeDataLayer";
	private static final String MEDICATION_REFILL_REQUEST_DATALAYER = "medicationRefillRequestDataLayer";
	private static final String CDW_PROBLEMDATALAYER_BEAN = "cdwProblemDataLayer";
	private static final String CDW_APPOINTMENTDATALAYER_BEAN = "cdw.appointment.datalayer";
	private static final String CDW_CHEMISTRYLABDATALAYER_BEAN = "cdw.lab-chemistry-result.datalayer";
	private static final String CDW_VITALSDATALAYER_BEAN = "cdw.vitals.datalayer";
	private static final String CDW_SURGERYDATALAYER_BEAN = "cdwSurgeryDatalayer";
	private static final String CDW_FACILITYDATALAYER_BEAN = "cdw.facility.datalayer";
	private static final String CDW_RADIOLOGYDATALAYER_BEAN = "cdwRadiologyDatalayer";
	private static final String CDW_MEDICATIONDATALAYER_BEAN = "cdwMedicationDatalayer";
	private static final String CDW_ALLERGYDATALAYER_BEAN = "cdwAllergyDatalayer";
	
    private static BeanFactory beanFactory = null;
    private static MhpObjectFactory instance = null;
    private static ApplicationContext springContext = null;

    public MhpObjectFactory() {
        LOGGER.debug("invoked default constructor");
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        springContext = applicationContext;
    }

	public static MhpObjectFactory getInstance() {
		if (instance == null) {
			initializeInstance();
		}
		return instance;
	}

	private synchronized static void initializeInstance() {
		if (instance == null) {
			LOGGER.debug("initalizing mhp object factory");
			instance = new MhpObjectFactory();
		}
	}

	@SuppressWarnings("unchecked")
	public <T> T getBean(String beanName) {
        T bean = (T) springContext.getBean(beanName);
//		T bean = (T) getBeanFactory().getBean(beanName);
		LOGGER.debug("loaded bean (without type safety)");
		return bean;
	}

	public <T> T getBean(String beanName, Class<T> requiredType) {
        T bean = (T)springContext.getBean(beanName, requiredType);
//		T bean = (T) getBeanFactory().getBean(beanName, requiredType);
		LOGGER.debug("loaded bean (with type safety)");
		return bean;
	}

	@Override
	public PatientDataLayer getPatientDataLayer() {
		return getBean(PATIENTDATALAYER_BEAN, PatientDataLayer.class);
	}

	@Override
	public AllergyDataLayer getAllergyDataLayer() {
		return getBean(ALLERGYDATALAYER_BEAN, AllergyDataLayer.class);
	}

	@Override
	public DocumentDataLayer getDocumentDataLayer() {
		return getBean(DOCUMENTDATALAYER_BEAN, DocumentDataLayer.class);
	}

	@Override
	public ProblemDataLayer getProblemDataLayer() {
		return getBean(PROBLEMDATALAYER_BEAN, ProblemDataLayer.class);
	}

	@Override
	public MedicationDataLayer getMedicationDataLayer() {
		return getBean(MEDICATIONDATALAYER_BEAN, MedicationDataLayer.class);
	}

	@Override
	public VitalDataLayer getVitalDataLayer(String source) {
		LOGGER.debug("determine vital data layer");
		String beanname;

		if (NullSafeStringComparer.areEqual(source, "patient")) {
			beanname = VITALDATALAYER_BEAN;
		} else if (NullSafeStringComparer.areEqual(source, "provider")) {
			beanname = VITALPROVIDERDATALAYER_BEAN;
		} else {
			beanname = VITALDATALAYER_BEAN;
		}

		LOGGER.debug("determined vital data layer for source, will use bean");
		return getBean(beanname, VitalDataLayer.class);
	}

	@Override
	public DietDataLayer getDietDataLayer() {
		return getBean(DIETDATALAYER_BEAN, DietDataLayer.class);
	}

	@Override
	public SurgeryDataLayer getSurgeryDataLayer() {
		return getBean(SURGERYDATALAYER_BEAN, SurgeryDataLayer.class);
	}

	@Override
	public ChemistryLabDataLayer getChemistryLabDataLayer() {
		return getBean(CHEMISTRYLABDATALAYER_BEAN, ChemistryLabDataLayer.class);
	}

	@Override
	public MicrobiologyLabDataLayer getMicrobiologyLabDataLayer() {
		return getBean(MICROBIOLOGYLABDATALAYER_BEAN, MicrobiologyLabDataLayer.class);
	}

	@Override
	public AppointmentDataLayer getAppointmentDataLayer() {
		return getBean(APPOINTMENTSDATALAYER_BEAN, AppointmentDataLayer.class);
	}

	@Override
	public AppointmentRequestDataLayer getAppointmentRequestDataLayer() {
		return getBean(APPOINTMENTREQUESTDATALAYER_BEAN, AppointmentRequestDataLayer.class);
	}

	public HealthCheckRunner getHealthCheckComponent() {
		return getBean(HEALTHCHECKCOMPONENT, HealthCheckRunner.class);
	}

	@Override
	public ContactLogDataLayer getContactLogDataLayer() {
		return getBean(CONTACTLOGDATALAYER_BEAN, ContactLogDataLayer.class);
	}

	@SuppressWarnings("unchecked")
	public HashMap<LabTestGroup, List<String>> chemistryLabGroupDefinitions() {
		return getBean(CHEMISTRY_LAB_GROUP_DEFINITION_BEAN, HashMap.class);
	}

	@Override
	public AdmissionDataLayer getAdmissionDataLayer() {
		return getBean(ADMISSIONDATALAYER_BEAN, AdmissionDataLayer.class);
	}

	@Override
	public MoodEventDataLayer getMoodEventDataLayer() {
		return getBean(MOODEVENTDATALAYER_BEAN, MoodEventDataLayer.class);
	}

	@Override
	public RadiologyDataLayer getRadiologyDataLayer() {
		return getBean(RADIOLOGYDATALAYER_BEAN, RadiologyDataLayer.class);
	}

	@Override
	public DailyEventDataLayer getDailyEventDataLayer() {
		return getBean(DAILYEVENTDATALAYER_BEAN, DailyEventDataLayer.class);
	}

	@Override
	public ExerciseDataLayer getExerciseDataLayer() {
		return getBean(EXERCISEDATALAYER_BEAN, ExerciseDataLayer.class);
	}

	@Override
	public NotificationDataLayer getNotificationDataLayer() {
		return getBean(NOTIFICATIONDATALAYER_BEAN, NotificationDataLayer.class);
	}

	@Override
	public NotificationCommunicationDataLayer getNotificationCommunicationDataLayer() {
		return getBean(NOTIFICATIONCOMMUNICATIONDATALAYER_BEAN, NotificationCommunicationDataLayer.class);
	}

	@Override
	public DeviceRegistrationDataLayer getDeviceRegistrationDataLayer() {
		return getBean(DEVICEREGISTRATIONDATALAYER_BEAN, DeviceRegistrationDataLayer.class);
	}

	@Override
	public CalendarKeyDataLayer getCalendarKeyDataLayer() {
		return getBean(CALENDARKEYDATALAYER_BEAN, CalendarKeyDataLayer.class);
	}

	@Override
	public MedicationRefillDataLayer getMedicationRefillDataLayer() {
		return getBean(MEDICATIONREFILLDATALAYER_BEAN, MedicationRefillDataLayer.class);
	}

	@Override
	public SecureMessageDataLayer getSecureMessageDataLayer() {
		return getBean(SECUREMESSAGEDATALAYER_BEAN, SecureMessageDataLayer.class);
	}

	public CalendarEventDataLayer getCalendarEventDataLayer() {
		return getBean(CALENDAR_EVENT_DATALAYER_BEAN, CalendarEventDataLayer.class);
	}

	@Override
	public RightOfAccessDataLayer getRightOfAccessDataLayer() {
		return getBean(RIGHT_OF_ACCESS_BEAN, RightOfAccessDataLayer.class);
	}

	@Override
	public AuditLogDataLayer getAuditLogDataLayer() {
		return getBean(AUDIT_LOG_BEAN, AuditLogDataLayer.class);
	}

	@Override
	public AssessmentDataLayer getAssessmentDataLayer() {
		return getBean(ASSESSMENT_DATALAYER_BEAN, AssessmentDataLayer.class);
	}

	@Override
	public LearnDataLayer getLearnDataLayer() {
		return getBean(LEARN_DATALAYER_BEAN, LearnDataLayer.class);
	}
	
	@Override
	public UserFeedbackDataLayer getUserFeedbackDataLayer() {
		return getBean(USERFEEDBACK_DATALAYER_BEAN, UserFeedbackDataLayer.class);
	}
	
	@Override
	public PatientMetadataDataLayer getPatientMetadataDataLayer() {
		return getBean(PATIENT_METADATA_DATALAYER_BEAN, PatientMetadataDataLayer.class);
	}
	
	public PatientCorrelationService getPatientCorrelationService () {
		return getBean(PATIENT_CORRELATION_BEAN, PatientCorrelationService.class);
	}
	
	@Override
	public FacilityDataLayer getFacilityDataLayer() {
		return getBean(FACILITY_DATALAYER_BEAN, FacilityDataLayer.class);
	}

	@Override
	public DetailCodeDataLayer getDetailCodeDataLayer() {
		return getBean(DETAIL_CODE_DATALAYER, DetailCodeDataLayer.class);
	}
	
	@Override
	public FacilityInternalDataLayer getFacilityInternalDataLayer() {
		return getBean(FACILITY_INTERNAL_DATALAYER, FacilityInternalDataLayer.class);
	}

	@Override
	public PatientInternalDataLayer getPatientInternalDataLayer() {
		return getBean(PATIENT_INTERNAL_DATALAYER, PatientInternalDataLayer.class);
	}
	
	@Override
	public AppointmentMetricsDataLayer getAppointmentMetricsDataLayer() {
		return getBean(APPOINTMENT_METRICS_DATALAYER, AppointmentMetricsDataLayer.class);
	}
	
	@Override
	public PatientPreferenceDataLayer getPatientPreferenceDataLayer(){
		return getBean(PATIENT_PREFERENCE_DATALAYER,PatientPreferenceDataLayer.class);
	}

	@Override
	public AppointmentRequestInProcessDataLayer getAppointmentRequestInProcessDataLayer() {
		return getBean(APPOINTMENTREQUESTINPROCESS_DATALAYER, AppointmentRequestInProcessDataLayer.class);
	}
	
	@Override
	public LaunchpadItemDataLayer getLaunchpadItemDataLayer() {
		return getBean(LAUNCHPAD_ITEM_DATALAYER, LaunchpadItemDataLayer.class);
	}

	@Override
	public MygoalsDataLayer getInventoryDataLayer() {
		return getBean(INVENTORY_DATALAYER, MygoalsDataLayer.class);
	}
	
	@Override
	public AntibiogramDataLayer getAntibiogramDataLayer() {
		return getBean(ANTIBIOGRAM_DATALAYER, AntibiogramDataLayer.class);
	}

	@Override
	public StaffUserDisclaimerDataLayer getStaffUserDisclaimerDataLayer() {
		return getBean(STAFF_USER_DISCLAIMER_DATALAYER, StaffUserDisclaimerDataLayer.class);
	}
	
	@Override
	public StaffDirectoryDataLayer getStaffDirectoryDataLayer() {
		return getBean(STAFF_DIRECTORY_DATALAYER, StaffDirectoryDataLayer.class);
	}
	
	@Override
	public MedicationRefillRequestDataLayer getMedicationRefillRequestDataLayer() {
		return getBean(MEDICATION_REFILL_REQUEST_DATALAYER, MedicationRefillRequestDataLayer.class);
	}

	public static <T> T initializeByType(Class<T> type) {
		T object;
		try {
			object = type.newInstance();
		} catch (InstantiationException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
		return object;
	}
	
	@Override
	public UserLastAccessedTimeDataLayer getUserLastAccessedTimeDataLayer() {
		return getBean(USER_LAST_ACCESSED_TIME_DATALAYER, UserLastAccessedTimeDataLayer.class);
	}
	
	@Override
	public CdwProblemDataLayer getCdwProblemDataLayer() {
		return getBean(CDW_PROBLEMDATALAYER_BEAN, CdwProblemDataLayer.class);
	}
	
	@Override
	public CdwAppointmentDataLayer getCdwAppointmentDataLayer() {
		return getBean(CDW_APPOINTMENTDATALAYER_BEAN, CdwAppointmentDataLayer.class);
	}
	
	@Override
	public CdwChemistryLabDataLayer getCdwChemistryLabDataLayer() {
		return getBean(CDW_CHEMISTRYLABDATALAYER_BEAN, CdwChemistryLabDataLayer.class);
	}
	
	@Override
	public CdwVitalsDataLayer getCdwVitalsDataLayer() {
		return getBean(CDW_VITALSDATALAYER_BEAN, CdwVitalsDataLayer.class);
	}
	
	@Override
	public CdwSurgeryDataLayer getCdwSurgeryDataLayer() {
		return getBean(CDW_SURGERYDATALAYER_BEAN, CdwSurgeryDataLayer.class);
	}
	
	@Override
	public CdwFacilityDataLayer getCdwFacilityDataLayer() {
		return getBean(CDW_FACILITYDATALAYER_BEAN, CdwFacilityDataLayer.class);
	}
	
	@Override
	public CdwRadiologyDataLayer getCdwRadiologyDataLayer() {
		return getBean(CDW_RADIOLOGYDATALAYER_BEAN, CdwRadiologyDataLayer.class);
	}
	
	@Override
	public CdwMedicationDataLayer getCdwMedicationDataLayer() {
		return getBean(CDW_MEDICATIONDATALAYER_BEAN, CdwMedicationDataLayer.class);
	}
	
	@Override
	public CdwAllergyDataLayer getCdwAllergyDataLayer() {
		return getBean(CDW_ALLERGYDATALAYER_BEAN, CdwAllergyDataLayer.class);
	}
}
