package com.agilex.healthcare.mobilehealthplatform.serviceregistry;

import com.agilex.healthcare.mobilehealthplatform.datalayer.UserLastAccessedTimeDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.admission.AdmissionDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.antibiogram.AntibiogramDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentMetricsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentRequestDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentRequestInProcessDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.DetailCodeDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.assessment.AssessmentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.audit.AuditLogDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.calendar.CalendarEventDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.calendar.CalendarKeyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.contactlog.ContactLogDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dailyevents.DailyEventDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.diet.DietDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.exercise.ExerciseDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityInternalDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.feedback.UserFeedbackDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.ChemistryLabDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro.MicrobiologyLabDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.launchpad.LaunchpadItemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.learn.LearnDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationRefillDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationRefillRequestDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.mood.MoodEventDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals.MygoalsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.DeviceRegistrationDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationCommunicationDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientInternalDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientMetadataDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.preference.PatientPreferenceDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.radiology.RadiologyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.rightofaccess.RightOfAccessDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage.SecureMessageDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.staffdirectory.StaffDirectoryDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer.StaffUserDisclaimerDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.surgery.SurgeryDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalDataLayer;
import com.agilex.healthcare.vamf.cdw.allergy.CdwAllergyDataLayer;
import com.agilex.healthcare.vamf.cdw.appointment.CdwAppointmentDataLayer;
import com.agilex.healthcare.vamf.cdw.chemlabs.CdwChemistryLabDataLayer;
import com.agilex.healthcare.vamf.cdw.facilities.CdwFacilityDataLayer;
import com.agilex.healthcare.vamf.cdw.medication.CdwMedicationDataLayer;
import com.agilex.healthcare.vamf.cdw.problems.CdwProblemDataLayer;
import com.agilex.healthcare.vamf.cdw.radiology.CdwRadiologyDataLayer;
import com.agilex.healthcare.vamf.cdw.surgery.CdwSurgeryDataLayer;
import com.agilex.healthcare.vamf.cdw.vitals.CdwVitalsDataLayer;

public interface DataLayerFactory {
	PatientDataLayer getPatientDataLayer();

	AllergyDataLayer getAllergyDataLayer();

	DocumentDataLayer getDocumentDataLayer();

	ProblemDataLayer getProblemDataLayer();

	MedicationDataLayer getMedicationDataLayer();

	MedicationRefillDataLayer getMedicationRefillDataLayer();

	VitalDataLayer getVitalDataLayer(String source);

	DietDataLayer getDietDataLayer();

	ChemistryLabDataLayer getChemistryLabDataLayer();

	MicrobiologyLabDataLayer getMicrobiologyLabDataLayer();

	ContactLogDataLayer getContactLogDataLayer();

	AppointmentDataLayer getAppointmentDataLayer();

	AppointmentRequestDataLayer getAppointmentRequestDataLayer();

	AppointmentMetricsDataLayer getAppointmentMetricsDataLayer();
	
	PatientPreferenceDataLayer getPatientPreferenceDataLayer();
	
	AdmissionDataLayer getAdmissionDataLayer();

	SurgeryDataLayer getSurgeryDataLayer();

	RadiologyDataLayer getRadiologyDataLayer();

	MoodEventDataLayer getMoodEventDataLayer();

	DailyEventDataLayer getDailyEventDataLayer();

	ExerciseDataLayer getExerciseDataLayer();

	NotificationDataLayer getNotificationDataLayer();

	NotificationCommunicationDataLayer getNotificationCommunicationDataLayer();

	DeviceRegistrationDataLayer getDeviceRegistrationDataLayer();

	CalendarEventDataLayer getCalendarEventDataLayer();

	CalendarKeyDataLayer getCalendarKeyDataLayer();

	SecureMessageDataLayer getSecureMessageDataLayer();

	RightOfAccessDataLayer getRightOfAccessDataLayer();

	AuditLogDataLayer getAuditLogDataLayer();

	AssessmentDataLayer getAssessmentDataLayer();

	LearnDataLayer getLearnDataLayer();
	
	UserFeedbackDataLayer getUserFeedbackDataLayer();
	
	PatientMetadataDataLayer getPatientMetadataDataLayer();
	
	FacilityDataLayer getFacilityDataLayer();
	
	DetailCodeDataLayer getDetailCodeDataLayer();
	
	FacilityInternalDataLayer getFacilityInternalDataLayer();
	
	PatientInternalDataLayer getPatientInternalDataLayer();

	AppointmentRequestInProcessDataLayer getAppointmentRequestInProcessDataLayer();
	
	LaunchpadItemDataLayer getLaunchpadItemDataLayer();
	
	MygoalsDataLayer getInventoryDataLayer();
	
	StaffUserDisclaimerDataLayer getStaffUserDisclaimerDataLayer();

	StaffDirectoryDataLayer getStaffDirectoryDataLayer();
	
	AntibiogramDataLayer getAntibiogramDataLayer();
	
	UserLastAccessedTimeDataLayer getUserLastAccessedTimeDataLayer();

	MedicationRefillRequestDataLayer getMedicationRefillRequestDataLayer();
	
	CdwProblemDataLayer getCdwProblemDataLayer();
	
	CdwAppointmentDataLayer getCdwAppointmentDataLayer();
	
	CdwChemistryLabDataLayer getCdwChemistryLabDataLayer();
	
	CdwVitalsDataLayer getCdwVitalsDataLayer();
	
	CdwSurgeryDataLayer getCdwSurgeryDataLayer();
	
	CdwFacilityDataLayer getCdwFacilityDataLayer();
	
	CdwRadiologyDataLayer getCdwRadiologyDataLayer();
	
	CdwMedicationDataLayer getCdwMedicationDataLayer();
	
	CdwAllergyDataLayer getCdwAllergyDataLayer();
	
}
