package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

import com.agilex.healthcare.mobilehealthplatform.datalayer.rightofaccess.RightOfAccessDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer.StaffUserDisclaimerDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.RightOfAccessInfo;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerInfo;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationService;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

public class VoterHelper {
    static PatientIdentifier getPatientIdentifierFromUri(String uri) {
        String id = null;
        String assigningAuthority = null;

        String[] uriTokens = uri.split("/");

        int patientTokenIndex = 0;
        boolean tokenFound = false;

        for (int i = 0; i < uriTokens.length; i++) {
            if ("patient".equals(uriTokens[i])) {
                patientTokenIndex = i;
                tokenFound = true;
                break;
            }
            if ("user".equals(uriTokens[i])) {
                patientTokenIndex = i + 1;
                tokenFound = true;
                break;
            }
            if("securemessage-service".equals(uriTokens[i])) {
                patientTokenIndex = i;
                tokenFound = true;
                break;
            }
        }

        if (tokenFound) {
            if (uriTokens.length > patientTokenIndex + 2) {
                assigningAuthority = uriTokens[patientTokenIndex + 1];
                id = uriTokens[patientTokenIndex + 2];
            }
            return new PatientIdentifier(assigningAuthority, id);
        } else {
            return new PatientIdentifier("", "");
        }

    }

    static boolean hasRole(Collection<? extends GrantedAuthority> authorities, String role) {
        for (GrantedAuthority grantedAuthority : authorities) {
            if (grantedAuthority.getAuthority().equals(role)) {
                return true;
            }
        }
        return false;
    }

    static PatientIdentifiers getPermittedPatientIdentifiers(Authentication authentication) {
        PatientIdentifier patientIdentifier = getUser(authentication).getPatient().getPatientIdentifier();

        PatientCorrelationService patientCorrelationService = MhpObjectFactory.getInstance().getPatientCorrelationService();
        PatientIdentifiers patientIdentifiers = patientCorrelationService.getCorrespondIdentifiers(patientIdentifier);

        return patientIdentifiers;
    }

    static MhpUser getUser(Authentication authentication) {
        return MhpUserFactory.createFromAuthentication(authentication);
    }

    static String getPath(FilterInvocation s) {
        HttpServletRequest httpRequest;
        FilterInvocation fi = s;
        httpRequest = fi.getRequest();

        return httpRequest.getRequestURI();
    }

    static  <S> HttpSession getHttpSession(S s) {
        HttpServletRequest request = ((FilterInvocation) s).getHttpRequest();
        HttpSession session = request.getSession();
        return session;
    }

    static Boolean getRightOfAccessAccepted(MhpUser mhpUser) {
        //get  value from dataservice, set it on mhpUser, test to ensure value sticks in context
        RightOfAccessDataService ds = new RightOfAccessDataService();
        RightOfAccessInfo rightOfAccessInfo = ds.getRightOfAccessInfo(mhpUser.getPatient().getPatientIdentifier().getUniqueId());
        if (rightOfAccessInfo != null){
            return  rightOfAccessInfo.isRightOfAccessAccepted();
        }
        else{
            return null;
        }
    }

    static Boolean getStaffUserDisclaimerAccepted(MhpUser mhpUser) {
        //get  value from dataservice, set it on mhpUser, test to ensure value sticks in context
    	StaffUserDisclaimerDataService ds = new StaffUserDisclaimerDataService();
    	StaffUserDisclaimerInfo staffUserDisclaimerInfo = ds.getStaffUserDisclaimerInfo(mhpUser.getVistaLocation(), mhpUser.getUserIdentifier().getUniqueId());
        if (staffUserDisclaimerInfo != null){
            return  staffUserDisclaimerInfo.isStaffUserDisclaimerAccepted();
        }
        else{
            return null;
        }
    }
}
