package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.Collection;

import javax.servlet.http.HttpSession;

import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;


public class StaffUserDisclaimerVoter<S> implements AccessDecisionVoter<S>{

	@Override
	public boolean supports(ConfigAttribute attribute) {
        return "CHECK_STAFF_USER_DISCLAIMER".equals(attribute.getAttribute());
	}

	@Override
	public boolean supports(Class<?> clazz) {
		return true;
	}

	
	//Deny or abstain, do not Grant
	@Override
	public int vote(Authentication authentication, S s,
			Collection<ConfigAttribute> attributes) {

        for (ConfigAttribute attribute : attributes) {

            if (supports(attribute)){
                if (VoterHelper.hasRole(authentication.getAuthorities(), Roles.ROLE_STAFF)){
                	// TODO: VOTER IS CURRENTLY TURNED OFF.  TURN BACK ON WHEN OTHER PROVIDER APPS IMPLEMENT SUD
                	//int sudVote = voteOnSud(s, authentication);
                    //return sudVote;
                	return AccessDecisionVoter.ACCESS_GRANTED;
                }
                else{
                    return AccessDecisionVoter.ACCESS_ABSTAIN;
                }
            }
        }
        return AccessDecisionVoter.ACCESS_ABSTAIN;
	}

//    private int voteOnSud(S s, Authentication authentication) {
//        //get sud from session
//        HttpSession session = VoterHelper.getHttpSession(s);
//        final String sudSessionKey = "StaffUserDisclaimerVoter.isStaffUserDisclaimerAccepted";
//        Boolean isStaffUserDisclaimerAccepted = (Boolean) session.getAttribute(sudSessionKey);
//
//        //if value is null, make dataservice call
//        if (isStaffUserDisclaimerAccepted == null) {
//            MhpUser user = MhpUserFactory.createFromAuthentication(authentication);
//            isStaffUserDisclaimerAccepted = VoterHelper.getStaffUserDisclaimerAccepted(user);
//
//            //Update session if value no longer null
//            if (isStaffUserDisclaimerAccepted != null && isStaffUserDisclaimerAccepted){
//                session.setAttribute(sudSessionKey, isStaffUserDisclaimerAccepted);
//            }
//        }
//
//        //use roa value for decision
//        if (isStaffUserDisclaimerAccepted == null || !isStaffUserDisclaimerAccepted) {
//            return AccessDecisionVoter.ACCESS_DENIED;
//        } else {
//            //user has accepted, grant access
//        	return AccessDecisionVoter.ACCESS_GRANTED;
//        }
//    }
}
