package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;


public class PatientInPilotVoter<S> implements AccessDecisionVoter<S>{

	@Override
	public boolean supports(ConfigAttribute attribute) {
		if ("IS_PROVIDER_PATIENT_ADVOCATE".equals(attribute.getAttribute())){
			return true;
		}
		else{
			return false;
		}
	}

	@Override
	public boolean supports(Class<?> clazz) {
		return true;
	}

	
	//Deny or abstain, do not Grant
	@Override
	public int vote(Authentication authentication, S s,
			Collection<ConfigAttribute> attributes) {
		
		
		if (checkPatientInPilot(authentication, s)){
			return AccessDecisionVoter.ACCESS_ABSTAIN;
		}
		else
			return AccessDecisionVoter.ACCESS_DENIED;
	}

	private boolean checkPatientInPilot(Authentication authentication, S s) {
		//Get the path that we can extract target patient information
		HttpServletRequest httpRequest = null;
		try {
			FilterInvocation fi = (FilterInvocation)s;
			httpRequest = (HttpServletRequest)fi.getRequest();
		} catch (Exception e) {
			return false;
		}

		String path = httpRequest.getRequestURI();
		PatientIdentifier targetPatientIdentifier = VoterHelper.getPatientIdentifierFromUri(path);

		if (targetPatientIdentifier.getUniqueId().equals("D123401") || targetPatientIdentifier.getUniqueId().equals("PATID26")){
			return true;
		}
		else{
			return false;
		}
	}
	
}
