package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;

public class MhpUserFactory {

	public static MhpUser createFromSecurityContext() {
		
        SecurityContext ctx = SecurityContextHolder.getContext();

        return createFromAuthentication(ctx.getAuthentication());
    }

    public static MhpUser createFromAuthentication(Authentication authentication) {
    	if(authentication == null){
    		return null;
    	}
    	
        if (authentication.getPrincipal() instanceof AppUser)
            return getMhpUserFromAppUser(authentication);
        else
            return null;
    }

    private static MhpUser getMhpUserFromAppUser(Authentication authentication) {
        AppUser appUser = (AppUser) authentication.getPrincipal();

        MhpUser mhpUser = appUser.getMhpUser();

        return mhpUser;
    }

	public static Set<String> getCurrentUserRoles() {

		SecurityContext securityContext = SecurityContextHolder.getContext();

        Authentication auth = securityContext.getAuthentication();
        UserDetails userDetails = (UserDetails) auth.getPrincipal();

        Set<String> roles = new HashSet<String>();

        Collection<? extends GrantedAuthority> grantedRoles = userDetails.getAuthorities();

        for (GrantedAuthority grantedAuthority : grantedRoles) {
			roles.add(grantedAuthority.getAuthority());
		}

		return roles;
	}

	public static boolean doesUserHasStaffRole(){
		boolean staff = false;

		if(getCurrentUserRoles().contains(Roles.ROLE_STAFF)){
			staff = true;
		}

		return staff;
	}

    public static void addSurrogateToPatientData(PatientData data) {
        if (SecurityContextHolder.getContext().getAuthentication() == null)
            return;

            MhpUser user = createFromSecurityContext();
        if (user != null && !user.userIsPatient() && data != null){
        	data.setSurrogateIdentifier("EDIPI", user.getId());
        }
    }

}
