package com.agilex.healthcare.mobilehealthplatform.restservice.exception;

import javax.ws.rs.core.*;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationRefillException;

@Provider
public class MedicationRefillExceptionMapper implements ExceptionMapper<MedicationRefillException>{

	@Override
	public Response toResponse(MedicationRefillException ex) {
		return Response.status(Status.BAD_REQUEST).entity(ex.getErrors()).type(MediaType.APPLICATION_JSON).build();
	}
}
