package com.agilex.healthcare.mobilehealthplatform.restservice.exception;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseException;

@Provider
public class MdwsResponseExceptionMapper implements ExceptionMapper<MdwsResponseException> {
    protected static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MdwsResponseExceptionMapper.class);

	private static final String CONNECTION_NOT_READY = "MDWSResponseException: Connections not ready for operation";

	@Override
	public Response toResponse(MdwsResponseException ex) {
		if(CONNECTION_NOT_READY.contains(ex.getMessage())) {
            logger.debug("MDWS Responded with Connection Not Ready. Returning Forbidden", ex);
			return Response.status(Status.FORBIDDEN).type(MediaType.TEXT_PLAIN_TYPE).build();
		} else {
            logger.debug("MDWS Responded with an unknown error. Returning Internal Error", ex);
			return Response.status(Status.INTERNAL_SERVER_ERROR).type(MediaType.TEXT_PLAIN_TYPE).build();
		}
	}
}
