package com.agilex.healthcare.mobilehealthplatform.restservice;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;

public abstract class AbstractUserResource {
	
	protected PatientIdentifier getPatientIdentifier() {
		return getCurrentUser().getPatient().getPatientIdentifier();
	}

	protected MhpUser getCurrentUser() {
		return MhpUserFactory.createFromSecurityContext();
	}
	
	protected String getCurrentUserId() {
		MhpUser mhpUser = getCurrentUser();

		if (mhpUser != null) {
			return mhpUser.getId();
		}
		
		return null;
	}
}
