package com.agilex.healthcare.mobilehealthplatform.idm;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.idm.get.IDMREQUEST;
import com.agilex.idm.response.IDENTIFIER;
import com.agilex.idm.response.IDMRESPONSE;
import com.agilex.vaidmclient.IdmWSClient;
import com.agilex.vapsim.CreateIdMTransaction;
import com.agilex.vapsim.dto.IdmGetIdRequestDTO;
import com.agilex.vapsim.dto.IdmIdentifierDTO;

public class IdmProxy implements PatientCorrelationWithEnterpriseSupport {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(IdmProxy.class);

	// TODO: make the URL config
	private static final String IDM_URL = "http://192.168.25.182:8080/VHAIdMSimulator/lookup";

	@Override
	public PatientIdentifiers getCorrespondIdentifiers(PatientIdentifier patientIdentifier) {
		IdmIdentifierDTO idmIdentifier = generateIdentifierDtoByDfn(patientIdentifier);
		PatientIdentifiers patientIdentifiers = getCorrespondingIdentifiers(idmIdentifier);
		return patientIdentifiers;
	}

	@Override
	public PatientIdentifier getEnterpriseIdentifier(PatientIdentifier patientIdentifier) {
		logger.debug("request to lookup icn by patient identifier");
		IdmIdentifierDTO idmIdentifier = generateIdentifierDtoByDfn(patientIdentifier);
		PatientIdentifiers correspondingIdentifiers = getCorrespondingIdentifiers(idmIdentifier);
		PatientIdentifier icnPatientIdentifier = null;
		for (PatientIdentifier correspondIdentifier : correspondingIdentifiers) {
			if (correspondIdentifier.getAssigningAuthority().contentEquals("IDM"))
				icnPatientIdentifier = correspondIdentifier;
		}
		logger.debug("request to lookup icn by patient identifier complete");
		return icnPatientIdentifier;
	}

	private IdmIdentifierDTO generateIdentifierDtoByIcn(String icn) {
		IdmIdentifierDTO vaICN = new IdmIdentifierDTO();
		vaICN.setId(icn);
		vaICN.setSource("IDM");
		vaICN.setType("NI");
		vaICN.setSubtype("IDM");
		vaICN.setIssuer("USVHA");
		return vaICN;
	}

	private IdmIdentifierDTO generateIdentifierDtoByDfn(PatientIdentifier patientIdentifier) {
		IdmIdentifierDTO vaICN = new IdmIdentifierDTO();
		vaICN.setId(patientIdentifier.getUniqueId());
		vaICN.setSource(patientIdentifier.getAssigningAuthority());
		vaICN.setType("PI");
		vaICN.setIssuer("USVHA");
		return vaICN;
	}

	private PatientIdentifiers getCorrespondingIdentifiers(IdmIdentifierDTO idmIdentifier) {
		IDMRESPONSE idmResponse;
		try {
			logger.debug("begin IDM call: createIdmGetCorrespondingIds");
			IdmGetIdRequestDTO requestDto = new IdmGetIdRequestDTO();
			requestDto.setIds(new IdmIdentifierDTO[] { idmIdentifier });
			IDMREQUEST idmRequest = CreateIdMTransaction.createIdmGetCorrespondingIds(requestDto);
			String xmlRequest = CreateIdMTransaction.marshallRequest(idmRequest);
			IdmWSClient ws = new IdmWSClient(IDM_URL);
			String xmlResponse;
			xmlResponse = ws.postGetCorrespondingIds(xmlRequest);
			idmResponse = CreateIdMTransaction.unmarshallResponse(xmlResponse);
			logger.debug("end IDM call: createIdmGetCorrespondingIds");
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		PatientIdentifiers patientIdentifiers = new PatientIdentifiers();
		if (idmResponse != null && idmResponse.getRESULT() != null) {
			for (IDENTIFIER identifier : idmResponse.getRESULT().getIDENTIFIER()) {
				// the if condition is filtering out the id that was used as
				// input
				if (!identifier.getSOURCE().contentEquals(idmIdentifier.getSource())) {
					PatientIdentifier patientIdentifier = new PatientIdentifier(identifier.getSOURCE(), identifier.getID());
					patientIdentifiers.add(patientIdentifier);
				}
			}
		}

		return patientIdentifiers;
	}

	@Override
	public PatientIdentifier getCorrespondIdentifier(PatientIdentifier patientIdentifier, String assigningAuthority) {
		return null;
	}

	@Override
	public PatientIdentifiers getCorrespondIdentifiersByEnterpriseIdentifier(PatientIdentifier enterpriseIdentifier) {
		return getCorrespondIdentifiersByIcn(enterpriseIdentifier.getUniqueId());
	}

	public PatientIdentifiers getCorrespondIdentifiersByIcn(String icn) {
		IdmIdentifierDTO idmIdentifier = generateIdentifierDtoByIcn(icn);
		PatientIdentifiers patientIdentifiers = getCorrespondingIdentifiers(idmIdentifier);
		return patientIdentifiers;
	}

	@Override
	public PatientIdentifier getCorrespondIdentifierByEnterpriseIdentifier(PatientIdentifier enterprisePatientIdentifier, String assigningAuthority) {
		IdmIdentifierDTO idmIdentifier = generateIdentifierDtoByIcn(enterprisePatientIdentifier.getUniqueId());
		PatientIdentifiers patientIdentifiers = getCorrespondingIdentifiers(idmIdentifier);
		PatientIdentifier matched = null;
		for (PatientIdentifier patientIdentifier : patientIdentifiers)
			if (patientIdentifier.getAssigningAuthority().contentEquals(assigningAuthority))
				matched = patientIdentifier;
		return matched;
	}

}
