package com.agilex.healthcare.mobilehealthplatform.ical;

import java.net.SocketException;

import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.UidGenerator;

import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvents;

public class ICalEventHelper {

	public static Calendar transformCalendarEventToICal(Calendar existingCalendar, CalendarEvents calendarEvents) {
		Calendar calendar = existingCalendar;
		if (calendar == null) {
			calendar = new Calendar();
		}

		for (CalendarEvent calendarEvent : calendarEvents) {
			VEvent event = convertCalendarEventToVEvent(calendarEvent);
			calendar.getComponents().add(event);
		}

		return calendar;
	}

	private static VEvent convertCalendarEventToVEvent(CalendarEvent calendarEvent) {
		Date start = new Date(calendarEvent.getStartDate());
		
		// Date end = new
		// Date(DateHelper.plusMinutes(calendarEvent.getStartDate(),
		// calendarEvent.getDuration()));
		Date end = start;
		
		String summary = calendarEvent.getTitle();

		VEvent event = new VEvent(start, end, summary);
		addAlarmToVEvent(calendarEvent, event);
		PropertyList properties = event.getProperties();
		properties.add(generateUid());
		properties.add(Clazz.PRIVATE);
		properties.add(new Description(calendarEvent.getNotes()));

		return event;
	}

	private static void addAlarmToVEvent(CalendarEvent calendarEvent, VEvent event) {
		int minuteOffset = calendarEvent.getAlertDuration();
		VAlarm alarm = new VAlarm(new Dur(0, 0, minuteOffset, 0));
		ComponentList componentList = event.getAlarms();
		componentList.add(alarm);
	}

	static Uid generateUid() {
		UidGenerator ug;
		try {
			ug = new UidGenerator("uidGen");
		} catch (SocketException e) {
			throw new RuntimeException("Could not generate UID via UidGenerator. ", e);
		}
		return ug.generateUid();
	}
}
