package com.agilex.healthcare.mobilehealthplatform.datalayer.vital;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.*;

public class VitalEntryRequestBuilder {
	private RequestMessage request;
	
	private VitalEntryRequestBuilder(RequestMessage request) {
		this.request = request;
	}
	
	public static VitalEntryRequestBuilder forVitalEntries() {
		RequestMessage request = new RequestMessage();
		request.setType("FetchVitalEntries");
		VitalEntryRequestBuilder builder = new VitalEntryRequestBuilder(request);
		return builder;
	}
	
	public static VitalEntryRequestBuilder forVitalEntry() {
		RequestMessage request = new RequestMessage();
		request.setType("FetchVitalEntry");
		VitalEntryRequestBuilder builder = new VitalEntryRequestBuilder(request);
		return builder;
	}
	
	public static VitalEntryRequestBuilder forPatientEntreredVitalEntries() {
		RequestMessage request = new RequestMessage();
		request.setType("FetchPatientEnteredVitalEntries");
		VitalEntryRequestBuilder builder = new VitalEntryRequestBuilder(request);
		return builder;
	}
	
	public static VitalEntryRequestBuilder forPatientEnteredVitalEntry() {
		RequestMessage request = new RequestMessage();
		request.setType("FetchPatientEnteredVitalEntry");
		VitalEntryRequestBuilder builder = new VitalEntryRequestBuilder(request);
		return builder;
	}
	
	public VitalEntryRequestBuilder forFilter(VitalEntryFilter filter) {
		request.setValue("vitals-filter", filter);
		return this;
	}
	
	public VitalEntryRequestBuilder forPatientIdentifier(PatientIdentifier patientIdentifier) {
		request.setValue("patient-identifier", patientIdentifier);
		return this;
	}
	
	public VitalEntryRequestBuilder forScope(ScopeFilter scopeFilter) {
		request.setValue("scope-filter", scopeFilter);
		return this;
	}
	
	public VitalEntryRequestBuilder forDataIdentifier(DataIdentifier dataIdentifier) {
		request.setValue("data-identifier", dataIdentifier);
		return this;
	}
	
	public VitalEntryRequestBuilder forDomain(String domain) {
		request.setValue("domain", domain);
		return this;
	}
	
	public RequestMessage build() {
		return request;
	}
}
