package com.agilex.healthcare.mobilehealthplatform.datalayer.vital;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.*;
import com.agilex.healthcare.mobilehealthplatform.utils.PatientIdentifierHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.vamf.cdw.vitals.CdwVitalsDataLayer;

public class VitalDataService {

	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(VitalDataService.class);
	private Router router;
	private CdwVitalsDataLayer layer;

	public VitalDataService() {
		this.router = new Router();
		layer = MhpObjectFactory.getInstance().getCdwVitalsDataLayer();
	}

	public VitalDataService(Router router) {
		this.router = router;
	}

	public VitalEntries fetchVitalEntries(PatientIdentifier patientIdentifier, VitalEntryFilter vitalFilter, ScopeFilter scopeFilter) {
		logger.debug("Retieving VitalEntries");
		
		/*RequestMessage request = VitalEntryRequestBuilder.forVitalEntries().forDomain(Domain.vital).forFilter(vitalFilter).forPatientIdentifier(patientIdentifier).forScope(scopeFilter).build();
		ResponseMessage response = router.execute(request);
		VitalEntries vitalEntries = PatientDataResponseReader.<VitalEntries, VitalEntry>fromResponse(response).getDataList();*/
		PatientIdentifiers icnPatientIdentifiers = PatientIdentifierHelper.translatePatientIdentifier(patientIdentifier, "ICN");
		if(NullChecker.isNullish(icnPatientIdentifiers))
			return new VitalEntries();
		VitalEntries vitalEntries = layer.fetchVitalEntries(icnPatientIdentifiers.get(0), vitalFilter);
		PatientIdentifierHelper.updatePatientIdentifier(vitalEntries, patientIdentifier);
		vitalEntries.sortDescending("entryDate");
		
		return vitalEntries;
	}
	
	public VitalEntry fetchVitalEntry(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier, ScopeFilter scopeFilter) {
		logger.debug("Retieving a single VitalEntry ");
		
		RequestMessage request = VitalEntryRequestBuilder.forVitalEntry().forDomain(Domain.vital).forDataIdentifier(dataIdentifier).forPatientIdentifier(patientIdentifier).forScope(scopeFilter).build();
		ResponseMessage response = router.execute(request);
		VitalEntry vitalEntry = PatientDataResponseReader.<VitalEntries, VitalEntry>fromResponse(response).getDataItem();
		
		return vitalEntry;
	}

}
