package com.agilex.healthcare.mobilehealthplatform.datalayer.surgery;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityCache;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgeries;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgery;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.PatientIdentifierHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.vamf.cdw.surgery.CdwSurgeryDataLayer;

public class SurgeryDataService {

	private Router router = new Router();
    private CdwSurgeryDataLayer layer;
    
	public SurgeryDataService() {
		layer = MhpObjectFactory.getInstance().getCdwSurgeryDataLayer();
	}
	
	public Surgeries getPatientSurgeries(PatientIdentifier patientIdentifier, DateFilter dateFilter, ScopeFilter scopeFilter) {
		/*RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.surgery).forPatientIdentifier(patientIdentifier).forScopeFilter(scopeFilter).forDateFilter(dateFilter).build();
		ResponseMessage responseMessage = router.execute(request);
		Surgeries surgeries = PatientDataResponseReader.<Surgeries, Surgery> fromResponse(responseMessage).getDataListNoNull(Surgeries.class);*/
		PatientIdentifiers dfnPatientIdentifiers = PatientIdentifierHelper.translatePatientIdentifier(patientIdentifier, "dfn");
		if(NullChecker.isNullish(dfnPatientIdentifiers))
			return new Surgeries();
		Surgeries surgeries = layer.fetchSurgeries(PatientIdentifierHelper.getDfnPatientidentifierForQuery(dfnPatientIdentifiers), dateFilter);
		PatientIdentifierHelper.updatePatientIdentifier(surgeries, patientIdentifier);
		surgeries.sortDescending("procedureDate");
		convertFacility(surgeries);
		return surgeries;
	}

	public Surgery fetchSurgery(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveSingleById().forDomain(Domain.surgery).forPatientIdentifier(patientIdentifier).forDataIdentifier(dataIdentifier).build();
		ResponseMessage responseMessage = router.execute(request);
		Surgery surgery = PatientDataResponseReader.<Surgeries, Surgery> fromResponse(responseMessage).getDataItem();
		convertFacility(surgery);
		return surgery;
	}
	
	private void convertFacility(Surgery result) {
		String facilityName = FacilityCache.getInstance().getFacilityName(result.getFacility());
		result.setFacility(facilityName);
		result.setSourceSystem(facilityName);
	}
	
	private void convertFacility(Surgeries results) {
		for (Surgery result : results) {
			convertFacility(result);
		}
	}
}
