package com.agilex.healthcare.mobilehealthplatform.datalayer.surgery;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class FetchSurgeryListRequestHandler extends AbstractFetchPatientDataListRequestHandler<SurgeryDataLayer, Surgeries, Surgery> {

	@Override
	protected Surgeries invokeDataLayerToFetchList(SurgeryDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.fetchSurgeries(messageReader.getPatientIdentifier(), messageReader.getDateFilter());
	}
}
