package com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerContent;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerInfo;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.utility.NullChecker;

public class StaffUserDisclaimerDataService {
	private StaffUserDisclaimerDataLayer datalayer;
	
	public StaffUserDisclaimerDataService() {
		datalayer = MhpObjectFactory.getInstance().getStaffUserDisclaimerDataLayer();
	}
	
	public StaffUserDisclaimerDataService(StaffUserDisclaimerDataLayer datalayer) {
		this.datalayer = datalayer;
	}

	public StaffUserDisclaimerInfo getStaffUserDisclaimerInfo(String vistaLocation, String userId) {
		StaffUserDisclaimerInfo info = datalayer.getStaffUserDisclaimerInfo(vistaLocation, userId);
		StaffUserDisclaimerContent content = datalayer.getLatestStaffUserDisclaimerContent();
		
		if (content.getDate().after(info.getStaffUserDisclaimerDate())) {
			info.setStaffUserDisclaimerAccepted(false);
		}
		
		return info;
	}

	public StaffUserDisclaimerInfo saveStaffUserDisclaimerInfo(StaffUserDisclaimerInfo staffUserDisclaimerInfo) {
		StaffUserDisclaimerInfo result = null;
		if (validate(staffUserDisclaimerInfo)) {
			result = datalayer.saveStaffUserDisclaimerInfo(staffUserDisclaimerInfo);
		} else {
			throw new WebApplicationException(Status.BAD_REQUEST);
		}
		
		return result;
	}
	
	public boolean validate(StaffUserDisclaimerInfo staffUserDisclaimerInfo) {
		boolean valid = false;
		if (NullChecker.isNotNullish(staffUserDisclaimerInfo.getUserId()) &&
				NullChecker.isNotNullish(staffUserDisclaimerInfo.getVistaLocation()) &&
				NullChecker.isNotNullish(staffUserDisclaimerInfo.getStaffUserDisclaimerDate())) {
			valid = true;
		}
		
		return valid;
	}

	public boolean isStaffUserDisclaimerAccepted(String vistaLocation, String userId) {
		boolean result = false;
		
		try {
			StaffUserDisclaimerInfo info = getStaffUserDisclaimerInfo(vistaLocation, userId);
			result = info.isStaffUserDisclaimerAccepted();
		} catch (WebApplicationException e) {
			if (e.getResponse().getStatus() != Status.NO_CONTENT.getStatusCode()) {
				throw e;
			}
		}
		return result;
	}
	
	public StaffUserDisclaimerContent getLatestStaffUserDisclaimerContent() {
		return datalayer.getLatestStaffUserDisclaimerContent();
	}
	
	public StaffUserDisclaimerContent saveStaffUserDisclaimerContent(StaffUserDisclaimerContent staffUserDisclaimerContent) {
		return datalayer.saveStaffUserDisclaimerContent(staffUserDisclaimerContent);
	}
}
