package com.agilex.healthcare.mobilehealthplatform.datalayer.staffdirectory;

import java.util.StringTokenizer;

import com.agilex.healthcare.mobilehealthplatform.domain.StaffDirectorySearchResults;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.utility.NullChecker;

public class StaffDirectoryDataService {
	
	StaffDirectoryDataLayer dataLayer = null;
	
	public StaffDirectoryDataService() {
		dataLayer = MhpObjectFactory.getInstance().getStaffDirectoryDataLayer();
	}
	
	public StaffDirectoryDataService(StaffDirectoryDataLayer dataLayer) {
		this.dataLayer = dataLayer;
	}
	
	public StaffDirectorySearchResults queryStaffBySite(String facilitySiteCode, String term) {
		StaffDirectorySearchResults staffDirectorySearchResults = new StaffDirectorySearchResults();
		
		if (NullChecker.isNotNullish(term)) {
			String trimmedTerm = term.trim().toUpperCase();
			
			if (trimmedTerm.contains("@")) {
				// favor email search
				staffDirectorySearchResults.addAll(dataLayer.searchByEmail(facilitySiteCode, trimmedTerm));
			} else if (trimmedTerm.contains(",") || trimmedTerm.contains(" ")) {
				// assume lastname,firstname or firstname lastname
				staffDirectorySearchResults.addAll(parseAndSearch(facilitySiteCode, trimmedTerm));
			} else {
				boolean isNumber = true;
				String firstCharacter = term.substring(0,1);
				try {
					Integer.parseInt(firstCharacter);
				} catch (NumberFormatException e) {
					isNumber = false;
				}
				
				if (isNumber) {
					// telephone number search
					staffDirectorySearchResults.addAll(dataLayer.searchByPhoneNumber(facilitySiteCode, trimmedTerm));
				} else {
					// single name search, favoring last name
					staffDirectorySearchResults.addAll(dataLayer.searchByFirstOrLastname(facilitySiteCode, "", trimmedTerm));
				}
			}
		}
		
		return staffDirectorySearchResults;
	}
	
	private StaffDirectorySearchResults parseAndSearch(String facilitySiteCode, String term) {
		StaffDirectorySearchResults staffDirectorySearchResults = new StaffDirectorySearchResults();
		
		String firstName = "";
		String lastName = "";
		
		if (term.contains(",")) {
			StringTokenizer st = new StringTokenizer(term, ", ");
			
			if (st.hasMoreTokens()) {
				lastName = st.nextToken();
			}
			if (st.hasMoreTokens()) {
				firstName = st.nextToken();
			}
		} else if (term.contains(" ")) {
			StringTokenizer st = new StringTokenizer(term, " ");
			
			if (st.hasMoreTokens()) {
				firstName = st.nextToken();
			}
			if (st.hasMoreTokens()) {
				lastName = st.nextToken();
			}
		}	
			
		if (NullChecker.isNotNullish(firstName) && NullChecker.isNotNullish(lastName)) {
			staffDirectorySearchResults.addAll(dataLayer.searchByFirstAndLastname(facilitySiteCode, firstName, lastName));
		}
		
		return staffDirectorySearchResults;
	}
}
