package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;


import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
    Stores a cache of the SecureMessageUser's id.

    When a user first attempts to access the /securemessage-service/ endpoints, a query is made by ICN to retrieve
    the user's id in the secure message database. This id is then used to build links for subsequent actions made by the
    user. This cache is used by our security frameworks to correlate a user's ICN and secure message id to ensure that
    the user can only access their own data.
 */
public class SecureMessageUserVerificationCache {

    private Map<String, String> userMap = null;
    private static SecureMessageUserVerificationCache instance = null;

    private SecureMessageUserVerificationCache() {
        userMap = new ConcurrentHashMap<String, String>();
    }

    public static SecureMessageUserVerificationCache getInstance() {
        if(instance == null) {
            instance = new SecureMessageUserVerificationCache();
        }
        return instance;
    }

    public String fetchUserId(PatientIdentifier patientIdentifier) {
        return userMap.get(patientIdentifier.getUniqueId());
    }

    public void saveUserId(PatientIdentifier patientIdentifier, String secureMessageUserId) {
        userMap.put(patientIdentifier.getUniqueId(), secureMessageUserId);
    }
}
