package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageUser;

public class SecureMessageUserResponseBuilder {
	private ResponseMessage response;
	
	private SecureMessageUserResponseBuilder(ResponseMessage response) {
		this.response = response;
	}
	
	public static SecureMessageUserResponseBuilder fromSecureMessageUser(SecureMessageUser user) {
		ResponseMessage response = new ResponseMessage();
		response.setValue("secure-message-user", user);
		SecureMessageUserResponseBuilder builder = new SecureMessageUserResponseBuilder(response);
		
		return builder;
	}
	
	public ResponseMessage build() {
		return response;
	}
}
