package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessages;

public class SecureMessageResponseBuilder {
	private ResponseMessage response;
	
	private SecureMessageResponseBuilder(ResponseMessage response) {
		this.response = response;
	}
	
	public static SecureMessageResponseBuilder getInstance() {
		return new SecureMessageResponseBuilder(new ResponseMessage());
	}
	
	public static SecureMessageResponseBuilder fromSecureMessage(SecureMessage dataItem) {
		ResponseMessage response = new ResponseMessage();
		SecureMessageResponseBuilder builder = new SecureMessageResponseBuilder(response);
		builder.setDataItem(dataItem);
		
		return builder;
	}
	
	public static SecureMessageResponseBuilder fromSecureMessages(SecureMessages dataList) {
		ResponseMessage response = new ResponseMessage();
		SecureMessageResponseBuilder builder = new SecureMessageResponseBuilder(response);
		builder.appendDataItems(dataList);
		return builder;
	}
	
	public SecureMessageResponseBuilder setDataItem(SecureMessage secureMessage) {
		response.setValue("secure-message", secureMessage);
		return this;
	}
	
	public SecureMessageResponseBuilder appendDataItems(SecureMessages secureMessages) {
		if(secureMessages != null) {
			SecureMessages existing = response.getValue("secure-messages");
			if(existing == null) {
				response.setValue("secure-messages", secureMessages);
			} else {
				existing.addAll(secureMessages);
			}
		}
		return this;
	}
	
	public ResponseMessage build() {
		return response;
	}
}
